package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;
import com.agilex.healthcare.utility.*;

public class AssessmentResultTranslator {
	
	public AssessmentResults translateMentalHealthInstrumentForPatient(TaggedMentalHealthResultSetArray mdwsTaggedMentalHealthResultSetArray) {
		AssessmentResults results = new AssessmentResults();
		
		if(mdwsTaggedMentalHealthResultSetArray == null)
			return results;
		
		
		return unwrapTaggedMentalHealthResultSetArray(mdwsTaggedMentalHealthResultSetArray.getItems());
	}
	
	AssessmentResults unwrapTaggedMentalHealthResultSetArray(ArrayOfMentalHealthInstrumentResultSetTO mdwsArrayOfTaggedHealthResultSet) {
		AssessmentResults results = new AssessmentResults();
		
		if(mdwsArrayOfTaggedHealthResultSet == null)
			return results;
		
		return unwrapListOfMHResultSets(mdwsArrayOfTaggedHealthResultSet.getMentalHealthInstrumentResultSetTO());
	}
	
	AssessmentResults unwrapListOfMHResultSets(List<MentalHealthInstrumentResultSetTO> mentalHealthResultSets) {
		AssessmentResults results = new AssessmentResults();
		
		if(NullChecker.isNullish(mentalHealthResultSets))
			return results;
		
		for(MentalHealthInstrumentResultSetTO mdwsMHResultSet : mentalHealthResultSets) {
			AssessmentResult result = createAssessmentResult(mdwsMHResultSet);
			results.add(result);
		}
		
		return results;
	}
	
	AssessmentResult createAssessmentResult(MentalHealthInstrumentResultSetTO mdwsMHResultSet) {
		AssessmentResult result = new AssessmentResult();
		
		result.setAssessmentId(mdwsMHResultSet.getAdministrationId());
		result.setScore(parseIntOrZero(mdwsMHResultSet.getRawScore()));
		result.setScoringAlgorithm(mdwsMHResultSet.getScale().getText());
		result.setDateTaken(tryToParseDate(mdwsMHResultSet.getSurveyGivenDateTime()));		
		result.setUniqueId(mdwsMHResultSet.getId());
		
		return result;
	}
	
	int parseIntOrZero(String value) {
		try {
			return Integer.parseInt(value);
		} catch (NumberFormatException couldNotParse) {
			return 0;
		}
	}
	
	Date tryToParseDate(String date) {
		try {
			return DateHelper.parseDate(date);
		} catch(RuntimeException couldNotParse) {
			return null;
		}
	}
	
}
