package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDateTranslationUtil;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;

public class AppointmentTranslator {
	
	public Appointments translate(TaggedAppointmentArrays taggedAppointments) {
		if(taggedAppointments == null)
			return new Appointments();
		
		return unwrapArrayOfTaggedAppointmentArray(taggedAppointments.getArrays());
	}
	
	private Appointments unwrapArrayOfTaggedAppointmentArray(ArrayOfTaggedAppointmentArray arrays) {
		if(arrays == null) 
			return new Appointments();
		
		return unwrapListOfTaggedAppointmentArray(arrays.getTaggedAppointmentArray());
	}
	
	private Appointments unwrapListOfTaggedAppointmentArray(List<TaggedAppointmentArray> taggedAppointmentArrays) {
		Appointments appointments = new Appointments();
		
		if(taggedAppointmentArrays == null || taggedAppointmentArrays.size() == 0)
			return appointments;
		
		for(TaggedAppointmentArray taggedArray : taggedAppointmentArrays) {
			appointments.addAll(unwrapArrayOfAppointment(taggedArray.getAppts()));
		}
		
		return appointments;
	}

	private Appointments unwrapArrayOfAppointment(ArrayOfAppointmentTO arrayOfAppointment) {
		if(arrayOfAppointment == null)
			return new Appointments();
		
		return unwrapListOfAppointments(arrayOfAppointment.getAppointmentTO());
	}
	
	private Appointments unwrapListOfAppointments(List<AppointmentTO> appointmentTos) {
		Appointments appointments = new Appointments();
		
		if(appointmentTos == null || appointmentTos.size() == 0)
			return appointments;
		
		for(AppointmentTO appointmentTo : appointmentTos) {
			appointments.add(constructAppointment(appointmentTo));
		}
		
		return appointments;
	}

	Appointment constructAppointment(AppointmentTO mdwsAppointment) {
		Appointment appointment = new Appointment();
		appointment.setUniqueId(mdwsAppointment.getId());
		
		if (mdwsAppointment.getVisitId() != null) {
			appointment.setStatus("kept");
		} else {
			appointment.setStatus(mdwsAppointment.getCurrentStatus());
		}
	
		appointment.setAppointmentStartDate(extractAppointmentDate(mdwsAppointment));
		appointment.setFacilityName(extractFacility(mdwsAppointment));
        appointment.setSourceSystem(appointment.getFacilityName());
		appointment.setClinicVisitId(mdwsAppointment.getVisitId());
		appointment.setProviderName(mdwsAppointment.getProviderName());
		tryToSetClinicInformation(appointment, mdwsAppointment);

		return appointment;
	}

	private Date extractAppointmentDate(AppointmentTO to) {
		MdwsDateTranslationUtil translator = new MdwsDateTranslationUtil();
		return translator.extractDateOrNull(to.getTimestamp());
	}
	
	void tryToSetClinicInformation(Appointment appointment, AppointmentTO mdwsAppointment) {
		HospitalLocationTO mdwsHospitalLocation = mdwsAppointment.getClinic();
		if (mdwsHospitalLocation != null) {
			appointment.setClinicName(mdwsHospitalLocation.getName());
			appointment.setClinicId(mdwsHospitalLocation.getId());
			appointment.setReasonForVisit(extractStopCode(mdwsAppointment));
			appointment.setClinicType(mdwsHospitalLocation.getType());
		}
	}
	
	private String extractStopCode(AppointmentTO appointment) {
		HospitalLocationTO clinic = appointment.getClinic();
		if(clinic == null)
			return null;
		
		TaggedText stopCode = clinic.getStopCode();
		if(stopCode == null)
			return null;
		
		return stopCode.getText();
	}
	
	private String extractFacility(AppointmentTO appointment) {
		TaggedText facility = appointment.getFacility();
		
		if(facility == null)
			return null;
		
		return facility.getText();
	}

}
