package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.Date;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDateTranslationUtil;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;
import com.agilex.healthcare.utility.*;

public class AllergyTranslator {

	public Allergies translate(TaggedAllergyArrays taggedAllergyArrays) {
		if(taggedAllergyArrays == null)
			return new Allergies();
		
		return unwrapArrayOfTaggedAllergyArray(taggedAllergyArrays.getArrays());
	}

	private Allergies unwrapArrayOfTaggedAllergyArray(ArrayOfTaggedAllergyArray arrays) {
		if(arrays == null)
			return new Allergies();
		
		return unwrapListOfTaggedAllergyArray(arrays.getTaggedAllergyArray());
	}
	
	private Allergies unwrapListOfTaggedAllergyArray(List<TaggedAllergyArray> taggedAllergyArrays) {
		Allergies allergies = new Allergies();
		
		if(taggedAllergyArrays == null || taggedAllergyArrays.size() == 0)
			return allergies;
		
		for(TaggedAllergyArray allergyArray : taggedAllergyArrays) {
			allergies.addAll(unwrapTaggedAllergyArray(allergyArray));
		}
		
		return allergies;
	}
	
	private Allergies unwrapTaggedAllergyArray(TaggedAllergyArray allergyArray) {
		if(allergyArray == null)
			return new Allergies();
		
		return unwrapArrayOfAllergyTo(allergyArray.getAllergies());
	}
	
	private Allergies unwrapArrayOfAllergyTo(ArrayOfAllergyTO arrayOfAllergies) {
		if(arrayOfAllergies == null) 
			return new Allergies();
		
		return unwrapListOfAllergyTos(arrayOfAllergies.getAllergyTO());
	}
	
	private Allergies unwrapListOfAllergyTos(List<AllergyTO> listOfAllergies) {
		Allergies allergies = new Allergies();
		
		if(listOfAllergies == null || listOfAllergies.size() == 0)
			return allergies;
		
		for(AllergyTO allergy : listOfAllergies) {
			allergies.add(constructAllergy(allergy));
		}
		
		return allergies;
	}
	
	private Allergy constructAllergy(AllergyTO allergyTo) {
		Allergy allergy = new Allergy();
		
		allergy.setCategory(allergyTo.getAllergenType());
		allergy.setSubstance(allergyTo.getAllergenName());
		allergy.setNote(allergyTo.getComment());
		allergy.setUniqueId(allergyTo.getAllergenId());
		allergy.setSeverity(allergyTo.getSeverity());
		allergy.setReaction(allergyTo.getReaction());
		allergy.setOnsetDate(extractDate(allergyTo));
		allergy.setSourceSystem(siteFromFacility(allergyTo));
		allergy.setReaction(extractReaction(allergyTo));
		
		return allergy;
	}
	
	private Date extractDate(AllergyTO to) {
		MdwsDateTranslationUtil translator = new MdwsDateTranslationUtil();
		return translator.extractDateOrNull(to.getTimestamp());
	}
	
	private String siteFromFacility(AllergyTO to) {
		TaggedText facility = to.getFacility();
		
		if(facility == null)
			return "";

        return TranslationHelper.alterFacilityName(facility.getText());
	}
	
	private String extractReaction(AllergyTO to) {
		return unwrapReactions(to.getReactions());
	}
	
	private String unwrapReactions(ArrayOfSymptomTO symptoms) {
		if(symptoms == null)
			return "";
		
		return unwrapSymptoms(symptoms.getSymptomTO());
	}
	
	private String unwrapSymptoms(List<SymptomTO> symptoms) {
		String symptomString = "";
		
		if(symptoms == null || symptoms.size() == 0)
			return symptomString;
		
		for(SymptomTO symptom : symptoms) {
			if(NullChecker.isNotNullish(symptom.getName()))
				symptomString += symptom.getName();
		}
		
		return symptomString;
	}
}
