package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDateTranslationUtil;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;

public class AdmissionTranslator {
	
	public Admissions translate(TaggedInpatientStayArray inpatientStayArray) {
		if(inpatientStayArray == null) 
			return new Admissions();
		
		return unwrapArrayOfInpatientStays(inpatientStayArray.getStays());
	}
	
	private Admissions unwrapArrayOfInpatientStays(ArrayOfInpatientStayTO stays) {
		if(stays == null)
			return new Admissions();
				
		return unwrapListOfInpatientStays(stays.getInpatientStayTO());
	}
	
	public Admissions unwrapListOfInpatientStays(List<InpatientStayTO> inpatientStays) {
		Admissions admissions = new Admissions();
		
		if(inpatientStays == null || inpatientStays.size() == 0)
			return admissions;
		
		for(InpatientStayTO inpatientStay : inpatientStays) {
			admissions.add(constructAdmission(inpatientStay));
		}
		
		return admissions;
	}
	
	private Admission constructAdmission(InpatientStayTO inpatientStay) {
		Admission admission = new Admission();
		
		admission.setUniqueId(inpatientStay.getMovementCheckinId());
		admission.setDischargeDate(translateDate(inpatientStay.getDischargeTimestamp()));
		admission.setAdmissionDate(translateDate(inpatientStay.getAdmitTimestamp()));
		admission.setFacilityName(translateFaciltityName(inpatientStay));
		
		return admission;
	}
	
	private Date translateDate(String timestamp) {
		MdwsDateTranslationUtil util = new MdwsDateTranslationUtil();
		return util.extractDateOrNull(timestamp);
	}
	
	private String translateFaciltityName(InpatientStayTO inpatientStay) {
		HospitalLocationTO location = inpatientStay.getLocation();
		return location.getName();
	}
}
