package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.Address;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.AddressTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfAddressTO;

public class AddressTranslator {
	
	public static Address translateFromMdwsAddress(ArrayOfAddressTO mdwsAddressWrapper) {
		List<AddressTO> mdwsAddressList = mdwsAddressWrapper.getAddressTO();
		AddressTO mdwsAddress = mdwsAddressList.get(0);
		Address address = new Address();
		
		address.setCity(mdwsAddress.getCity());
		address.setState(mdwsAddress.getState());
		address.setZipCode(mdwsAddress.getZipcode());
		address.setStreetAddressLine1(mdwsAddress.getStreetAddress1());
		address.setStreetAddressLine2(mdwsAddress.getStreetAddress2());
		address.setStreetAddressLine3(mdwsAddress.getStreetAddress3());
		
		return address;
	}
}
