package com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer;

import java.net.URL;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Logger;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.MhvService;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.MhvServiceSoap;

public class MhvSoapHelper {

	private final static Logger logger = Logger.getLogger(MhvSoapHelper.class);

	public static MhvServiceSoap getPort(MhvMdwsConfiguration mdwsConfiguration) {
		URL wsdlLocation = constructWSDLURL(mdwsConfiguration.getMdwsEndpointUrl());
		MhvService service = new MhvService(wsdlLocation);
		
		MhvServiceSoap port = service.getMhvServiceSoap();
		((BindingProvider)port).getRequestContext().put(BindingProvider.SESSION_MAINTAIN_PROPERTY, false);
		((BindingProvider) port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, mdwsConfiguration.getMdwsEndpointUrl());
        ((BindingProvider) port).getRequestContext().put("javax.xml.ws.client.connectionTimeout", mdwsConfiguration.getWsConnectTimeout());
        ((BindingProvider) port).getRequestContext().put("javax.xml.ws.client.receiveTimeout", mdwsConfiguration.getWsRequestTimeout());

		return port;
	}
	
	public static MhvServiceSoap getPort(MdwsConfiguration mdwsConfiguration) {
		URL wsdlLocation = constructWSDLURL(mdwsConfiguration.getEndPointUrl());
		MhvService service = new MhvService(wsdlLocation);
		
		MhvServiceSoap port = service.getMhvServiceSoap();
		((BindingProvider) port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, mdwsConfiguration.getEndPointUrl());
		
		return port;
	}

	private static URL constructWSDLURL(String endPointUrl) {
		String wsdlLocation = endPointUrl + "?WSDL";
		URL wsdlLocationURL = null;
		try {
			wsdlLocationURL = new URL(wsdlLocation);
		} catch (Exception e) {
			logger.debug("Exception while constructing MhvService URL object");
			throw new RuntimeException("Secure Messaging is not available at this time");
		}

		return wsdlLocationURL;
	}

}
