package com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer;

public class MhvMdwsConfiguration {
	
	private String mdwsEndpointAddress;
	private String mdwsEndpointPath;
	private String mdwsSitecode; // no longer used (retrieved from patient)
	private String mhvDatabaseAddress;
	private String mhvDatabasePort;
	private String mhvDatabaseMinimumPoolSize;
	private String mhvDatabaseMaximumPoolSize;
	private String sid; // used for internal testing
    private String mhvDatabaseServiceName;
    private String mhvDatabaseUsername; 
    private String mhvDatabasePassword;
	private boolean serviceConnection; // whether to use service name or sid in the connection string
    private int wsConnectTimeout;
    private int wsRequestTimeout;

	public String getMdwsEndpointAddress() {
		return mdwsEndpointAddress;
	}

	public void setMdwsEndpointAddress(String mdwsEndpointAddress) {
		this.mdwsEndpointAddress = mdwsEndpointAddress;
	}

	public String getMdwsEndpointPath() {
		return mdwsEndpointPath;
	}

	public void setMdwsEndpointPath(String mdwsEndpointPath) {
		this.mdwsEndpointPath = mdwsEndpointPath;
	}

	public String getMdwsSitecode() {
		return mdwsSitecode;
	}

	public void setMdwsSitecode(String mdwsSitecode) {
		this.mdwsSitecode = mdwsSitecode;
	}

	public String getMhvDatabaseAddress() {
		return mhvDatabaseAddress;
	}

	public void setMhvDatabaseAddress(String mhvDatabaseAddress) {
		this.mhvDatabaseAddress = mhvDatabaseAddress;
	}

	public String getMhvDatabasePort() {
		return mhvDatabasePort;
	}

	public void setMhvDatabasePort(String mhvDatabasePort) {
		this.mhvDatabasePort = mhvDatabasePort;
	}

	public String getMhvDatabaseMinimumPoolSize() {
		return mhvDatabaseMinimumPoolSize;
	}

	public void setMhvDatabaseMinimumPoolSize(String mhvDatabaseMinimumPoolSize) {
		this.mhvDatabaseMinimumPoolSize = mhvDatabaseMinimumPoolSize;
	}

	public String getMhvDatabaseMaximumPoolSize() {
		return mhvDatabaseMaximumPoolSize;
	}

	public void setMhvDatabaseMaximumPoolSize(String mhvDatabaseMaximumPoolSize) {
		this.mhvDatabaseMaximumPoolSize = mhvDatabaseMaximumPoolSize;
	}

	public String getMhvDatabaseServiceName() {
		return mhvDatabaseServiceName;
	}

	public void setMhvDatabaseServiceName(String mhvDatabaseServiceName) {
		this.mhvDatabaseServiceName = mhvDatabaseServiceName;
	}
	
	public String getMhvDatabaseUsername() {
		return mhvDatabaseUsername;
	}

	public void setMhvDatabaseUsername(String mhvDatabaseUsername) {
		this.mhvDatabaseUsername = mhvDatabaseUsername;
	}

	public String getMhvDatabasePassword() {
		return mhvDatabasePassword;
	}

	public void setMhvDatabasePassword(String mhvDatabasePassword) {
		this.mhvDatabasePassword = mhvDatabasePassword;
	}

	public String getSid() {
		return sid;
	}

	public void setSid(String sid) {
		this.sid = sid;
	}

	public String getServiceName() {
		return mhvDatabaseServiceName;
	}

	public void setServiceName(String serviceName) {
		this.mhvDatabaseServiceName = serviceName;
	}

	public boolean isServiceConnection() {
		return serviceConnection;
	}

	public void setServiceConnection(boolean serviceConnection) {
		this.serviceConnection = serviceConnection;
	}

	public String getMdwsEndpointUrl() {
		return String.format("http://%s/%s/MhvService.asmx", mdwsEndpointAddress, mdwsEndpointPath);
	}

	public String getMdwsPwdWithSid() {
		return String.format("Min Pool Size=%s;Max Pool Size=%s;Connection Lifetime=120;Connection Timeout=10;Data Source=(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=%s)(PORT=%s))(CONNECT_DATA=(SID=%s)));User ID=%s;Password=%s", 
				mhvDatabaseMinimumPoolSize, mhvDatabaseMaximumPoolSize, mhvDatabaseAddress, mhvDatabasePort, sid, mhvDatabaseUsername, mhvDatabasePassword);
	}

	public String getMdwsPwdWithService() {
		return String.format("Min Pool Size=%s;Max Pool Size=%s;Connection Lifetime=120;Connection Timeout=10;Data Source=(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=%s)(PORT=%s)))(CONNECT_DATA=(SERVICE_NAME=%s)));User ID=%s;Password=%s", 
				mhvDatabaseMinimumPoolSize, mhvDatabaseMaximumPoolSize, mhvDatabaseAddress, mhvDatabasePort, mhvDatabaseServiceName, mhvDatabaseUsername, mhvDatabasePassword);
	}


    public int getWsConnectTimeout() {
        return wsConnectTimeout;
    }

    public void setWsConnectTimeout(int wsConnectTimeout) {
        this.wsConnectTimeout = wsConnectTimeout;
    }

    public int getWsRequestTimeout() {
        return wsRequestTimeout;
    }

    public void setWsRequestTimeout(int wsRequestTimeout) {
        this.wsRequestTimeout = wsRequestTimeout;
    }

	public String getSecureMessageMinimumPoolSize() {
		return mhvDatabaseMinimumPoolSize;
	}

	public void setSecureMessageMinimumPoolSize(String secureMessageMinimumPoolSize) {
		this.mhvDatabaseMinimumPoolSize = secureMessageMinimumPoolSize;
	}

	public String getSecureMessageMaximumPoolSize() {
		return mhvDatabaseMaximumPoolSize;
	}

	public void setSecureMessageMaximumPoolSize(String secureMessageMaximumPoolSize) {
		this.mhvDatabaseMaximumPoolSize = secureMessageMaximumPoolSize;
	}
}
