package com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer;

import com.agilex.healthcare.mobilehealthplatform.domain.code.AssigningAuthorityCode;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDataSourceCode;

public class MdwsConfigurationHelper {
	public static final String CDW_SITECODE = "204";
	public static final String CDW_RAW_SITECODE = "205";

	private final static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MdwsConfigurationHelper.class);

	public String extractSiteCodeFromAssigningAuthority(String assigningAuthority) {
		String siteCode = "";
		String siteType = "";
		
		if (AssigningAuthorityCode.ICN.equalsIgnoreCase(assigningAuthority)) {
			siteCode = CDW_SITECODE;
		} else {
			int length = assigningAuthority.length();
			if (length == 7) {
				siteType = assigningAuthority.substring(0, 3);
				if (siteType.equalsIgnoreCase("DFN")) {
					siteCode = assigningAuthority.substring(length - 3, length);
				} else {
					logger.error("Cannot extract SiteCode");
				}
			}
		}
		
		return siteCode;
	}

	public String extractSiteTypeFromAssigningAuthority(String assigningAuthority) {

		if (assigningAuthority.equalsIgnoreCase(AssigningAuthorityCode.ICN))
			return MdwsDataSourceCode.CDW;
		else
			return MdwsDataSourceCode.VISTA;

	}

}
