package com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer;

import java.util.HashMap;

public class MdwsConfiguration {

	private String endPointBaseUrl;
	private String endPointUrl;

	private int wsConnectTimeout;
	private int wsRequestTimeout;

	private HashMap<String, VistaSite> vistaSites;

	public MdwsConfiguration() {

	}

	public MdwsConfiguration(String endPointUrl, int wsRequestTimeout, int wsConnectTimeout, HashMap<String, VistaSite> vistaSites) {
		this.endPointUrl = endPointUrl;
		this.wsConnectTimeout = wsConnectTimeout;
		this.wsRequestTimeout = wsRequestTimeout;
		this.vistaSites = vistaSites;
	}
	
	public MdwsConfiguration(String endPointBaseUrl, String endPointUrl, int wsRequestTimeout, int wsConnectTimeout, HashMap<String, VistaSite> vistaSites) {
		this(endPointUrl, wsRequestTimeout, wsConnectTimeout, vistaSites);
		this.endPointBaseUrl = endPointBaseUrl;
	}

	public String getEndPointUrl() {
		return endPointUrl;
	}

	public void setEndPointUrl(String endPointUrl) {
		this.endPointUrl = endPointUrl;
	}

	public int getWsConnectTimeout() {
		return wsConnectTimeout;
	}

	public void setWsConnectTimeout(int wsConnectTimeout) {
		this.wsConnectTimeout = wsConnectTimeout;
	}

	public int getWsRequestTimeout() {
		return wsRequestTimeout;
	}

	public void setWsRequestTimeout(int wsRequestTimeout) {
		this.wsRequestTimeout = wsRequestTimeout;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();

		builder.append("\nEndpointUrl: ");
		builder.append(getEndPointUrl());

		return builder.toString();

	}

	public HashMap<String, VistaSite> getVistaSites() {
		return vistaSites;
	}

	public VistaSite getVistaSite(String siteCode) {
		VistaSite vistaSite = null;
		if (vistaSites != null)
			vistaSite = vistaSites.get(siteCode);
		else {
			throw new RuntimeException("Cannot find vista sites configuration");
		}
		return vistaSite;
	}

	public String getEndPointBaseUrl() {
		return endPointBaseUrl;
	}

	public void setEndPointBaseUrl(String endPointBaseUrl) {
		this.endPointBaseUrl = endPointBaseUrl;
	}

}
