package com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;

/**
 * This class was generated by Apache CXF 3.0.1
 * 2014-09-19T16:41:12.444-04:00
 * Generated source version: 3.0.1
 * 
 */
@WebService(targetNamespace = "http://mdws.domain/EmrSvc", name = "EmrSvcHttpGet")
@XmlSeeAlso({ObjectFactory.class})
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
public interface EmrSvcHttpGet {

    /**
     * Get treating specialty from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getTreatingSpecialtyReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Validate electronic signature
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO isValidEsig(
        @WebParam(partName = "esig", name = "esig", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String esig
    );

    /**
     * Get discharge summaries from all connected VistAs.
     */
    @WebResult(name = "TaggedNoteArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedNoteArrays getDischargeSummaries(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nNotes", name = "nNotes", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nNotes
    );

    /**
     * Retrieves all Mental Health Instruments For a Patient given a Survey acronym
     */
    @WebResult(name = "TaggedMentalHealthInstrumentAdministrationArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedMentalHealthInstrumentAdministrationArrays getMentalHealthInstrumentsForPatientBySurvey(
        @WebParam(partName = "surveyName", name = "surveyName", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String surveyName
    );

    /**
     * Get surgery reports from all connected VistAs
     */
    @WebResult(name = "TaggedSurgeryReportArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedSurgeryReportArrays getSurgeryReports();

    /**
     * Is given note a consult note?
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO isConsultNote(
        @WebParam(partName = "noteDefinitionIEN", name = "noteDefinitionIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String noteDefinitionIEN
    );

    /**
     * Get patient's clinical warnings.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getClinicalWarnings(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get past clinic visits from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getPastClinicVisitsReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get a list of patients by specialty
     */
    @WebResult(name = "TaggedPatientArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedPatientArray getPatientsBySpecialty(
        @WebParam(partName = "specialtyId", name = "specialtyId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String specialtyId
    );

    /**
     * Set the current session's sites file
     */
    @WebResult(name = "SiteArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public SiteArray setVha(
        @WebParam(partName = "sitesFileName", name = "sitesFileName", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String sitesFileName
    );

    /**
     * Is given note a surgery note?
     */
    @WebResult(name = "TaggedText", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedText isSurgeryNote(
        @WebParam(partName = "noteDefinitionIEN", name = "noteDefinitionIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String noteDefinitionIEN
    );

    /**
     * Get patient record flag actions.
     */
    @WebResult(name = "PatientRecordFlagArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public PatientRecordFlagArray getPrfNoteActions(
        @WebParam(partName = "noteDefinitionIEN", name = "noteDefinitionIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String noteDefinitionIEN
    );

    /**
     * Get the list of teams
     */
    @WebResult(name = "TaggedText", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedText getTeams();

    /**
     * Dynamically retrieve current list of Active Directory domains
     */
    @WebResult(name = "DomainArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public DomainArray getActiveDirectoryDomains();

    /**
     * Get care team from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getCareTeamReports();

    /**
     * Get future clinic visits from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getFutureClinicVisitsReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get patient's Cytology lab results.
     */
    @WebResult(name = "TaggedCytologyRptArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedCytologyRptArrays getCytologyReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getNhinData(
        @WebParam(partName = "types", name = "types", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String types
    );

    /**
     * Is given note a PRF note?
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO isPrfNote(
        @WebParam(partName = "noteDefinitionIEN", name = "noteDefinitionIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String noteDefinitionIEN
    );

    /**
     * Get patient's autopsy reports.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getAutopsyReports();

    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getClinicsByName(
        @WebParam(partName = "name", name = "name", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String name
    );

    /**
     * Get patient's meds administation log.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getMedsAdminLog(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get patient's immunizations.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getImmunizations(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Is given note a surgery note?
     */
    @WebResult(name = "TaggedText", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedText isOneVisitNote(
        @WebParam(partName = "noteDefinitionIEN", name = "noteDefinitionIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String noteDefinitionIEN,
        @WebParam(partName = "noteTitle", name = "noteTitle", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String noteTitle,
        @WebParam(partName = "visitString", name = "visitString", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String visitString
    );

    @WebResult(name = "TaggedText", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedText getPcpForPatient(
        @WebParam(partName = "pid", name = "pid", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String pid
    );

    /**
     * Get MDWS Version
     */
    @WebResult(name = "string", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public java.lang.String getMDWSVersion();

    /**
     * Get a list of patients by ward
     */
    @WebResult(name = "TaggedPatientArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedPatientArray getPatientsByWard(
        @WebParam(partName = "wardId", name = "wardId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String wardId
    );

    /**
     * Get a VistA's hospital locations (clinics, etc.).
     */
    @WebResult(name = "TaggedHospitalLocationArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedHospitalLocationArray getLocations(
        @WebParam(partName = "target", name = "target", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String target,
        @WebParam(partName = "direction", name = "direction", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String direction
    );

    /**
     * Get a note from a single connected VistA.
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO getNote(
        @WebParam(partName = "siteId", name = "siteId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String siteId,
        @WebParam(partName = "noteId", name = "noteId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String noteId
    );

    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO getOrderStatusForPatient(
        @WebParam(partName = "pid", name = "pid", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String pid,
        @WebParam(partName = "orderableItemId", name = "orderableItemId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String orderableItemId
    );

    /**
     * Get patient's appointments.
     */
    @WebResult(name = "TaggedAppointmentArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedAppointmentArrays getAppointments();

    /**
     * Get text for a certain surgery report
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO getSurgeryReportText(
        @WebParam(partName = "siteId", name = "siteId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String siteId,
        @WebParam(partName = "rptId", name = "rptId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String rptId
    );

    /**
     * Get outpatient medications from all connected VistAs
     */
    @WebResult(name = "TaggedMedicationArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedMedicationArrays getOutpatientMeds();

    /**
     * Get patient's blood transfusion reports.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getBloodTransfusionReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get patient's blood availability reports.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getBloodAvailabilityReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get a list of patients by team
     */
    @WebResult(name = "TaggedPatientArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedPatientArray getPatientsByTeam(
        @WebParam(partName = "teamId", name = "teamId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String teamId
    );

    /**
     * Get patient associates (NOK, caregiver, etc.)
     */
    @WebResult(name = "TaggedPatientAssociateArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedPatientAssociateArrays getPatientAssociates();

    /**
     * Get notes with text from all connected VistAs.
     */
    @WebResult(name = "TaggedNoteArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedNoteArrays getNotesWithText(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nNotes", name = "nNotes", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nNotes
    );

    /**
     * Get patient's adhoc health summary by display name from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getAdhocHealthSummaryByDisplayName(
        @WebParam(partName = "displayName", name = "displayName", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String displayName
    );

    /**
     * Get a patient's demographics
     */
    @WebResult(name = "PatientTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public PatientTO getDemographics();

    /**
     * Retrieves all Mental Health Instruments for a Patient
     */
    @WebResult(name = "TaggedMentalHealthInstrumentAdministrationArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedMentalHealthInstrumentAdministrationArrays getMentalHealthInstrumentsForPatient();

    /**
     * Get patient's cytopathology reports.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getCytopathologyReports();

    @WebResult(name = "UserSecurityKeyArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public UserSecurityKeyArray getUserSecurityKeys(
        @WebParam(partName = "uid", name = "uid", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String uid
    );

    /**
     * Get patient's electron microscopy reports.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getElectronMicroscopyReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Lookup a user in Active Directory. Can search by username, email address or GUID
     */
    @WebResult(name = "UserArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public UserArray ldapUserLookup(
        @WebParam(partName = "uid", name = "uid", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String uid,
        @WebParam(partName = "domainSearchRoot", name = "domainSearchRoot", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String domainSearchRoot
    );

    /**
     * Get the list of menu options assigned to the user.
     */
    @WebResult(name = "UserMenuOptionArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public UserMenuOptionArray getUserMenuOptions(
        @WebParam(partName = "userId", name = "userId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String userId
    );

    /**
     * Get selected patient's admissions
     */
    @WebResult(name = "TaggedInpatientStayArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedInpatientStayArray getAdmissions();

    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO getVariableValue(
        @WebParam(partName = "arg", name = "arg", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String arg
    );

    @WebResult(name = "TextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextArray getReminderReportTemplates();

    /**
     * Get the list of specialties
     */
    @WebResult(name = "TaggedText", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedText getSpecialties();

    /**
     * Get discharge reports from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getDischargesReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Verify Active Directory credentials
     */
    @WebResult(name = "UserTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public UserTO loginActiveDirectory(
        @WebParam(partName = "domain", name = "domain", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String domain,
        @WebParam(partName = "username", name = "username", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String username,
        @WebParam(partName = "password", name = "password", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String password
    );

    /**
     * Get note for appointment.
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO getAppointmentText(
        @WebParam(partName = "siteId", name = "siteId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String siteId,
        @WebParam(partName = "apptId", name = "apptId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String apptId
    );

    /**
     * Get radiology reports for a CDW connection
     */
    @WebResult(name = "TaggedRadiologyReportArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedRadiologyReportArrays getRadiologyReportsBySite(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "siteCode", name = "siteCode", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String siteCode
    );

    /**
     * Get un      ed note metadata from all connected VistAs
     */
    @WebResult(name = "TaggedNoteArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedNoteArrays getUn      edNotes(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nNotes", name = "nNotes", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nNotes
    );

    /**
     * Get signed note metadata from all connected VistAs
     */
    @WebResult(name = "TaggedNoteArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedNoteArrays getSignedNotes(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nNotes", name = "nNotes", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nNotes
    );

    @WebResult(name = "RadiologyReportTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public RadiologyReportTO getImagingReport(
        @WebParam(partName = "SSN", name = "SSN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String ssn,
        @WebParam(partName = "accessionNumber", name = "accessionNumber", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String accessionNumber
    );

    /**
     * Get ICD procedure reports from all connected VistAs.
     */
    @WebResult(name = "TaggedIcdRptArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedIcdRptArrays getIcdProceduresReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get IV medications from all connected VistAs
     */
    @WebResult(name = "TaggedMedicationArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedMedicationArrays getIvMeds();

    /**
     * Get a list of hospital wards
     */
    @WebResult(name = "TaggedHospitalLocationArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedHospitalLocationArray getWards();

    /**
     * Get Inpatient for Outpatient medications from all connected VistAs
     */
    @WebResult(name = "TaggedMedicationArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedMedicationArrays getImoMeds();

    /**
     * Get problem list from all connected VistAs
     */
    @WebResult(name = "TaggedProblemArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedProblemArrays getProblemList(
        @WebParam(partName = "type", name = "type", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String type
    );

    /**
     * Get the list of available Health Factors.
     */
    @WebResult(name = "TaggedHealthFactorArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedHealthFactorArray getHealthFactors();

    /**
     * Write a note.
     */
    @WebResult(name = "NoteResultTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public NoteResultTO writeNote(
        @WebParam(partName = "titleIEN", name = "titleIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String titleIEN,
        @WebParam(partName = "encounterString", name = "encounterString", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String encounterString,
        @WebParam(partName = "text", name = "text", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String text,
        @WebParam(partName = "authorDUZ", name = "authorDUZ", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String authorDUZ,
        @WebParam(partName = "      erDUZ", name = "      erDUZ", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String       erDUZ,
        @WebParam(partName = "consultIEN", name = "consultIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String consultIEN,
        @WebParam(partName = "prfIEN", name = "prfIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String prfIEN
    );

    /**
     * Disconnect from all connected Vista systems.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray disconnect();

    /**
     * Write a simple, by policy order to a single VistA
     */
    @WebResult(name = "OrderTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public OrderTO writeSimpleOrderByPolicy(
        @WebParam(partName = "providerDUZ", name = "providerDUZ", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String providerDUZ,
        @WebParam(partName = "esig", name = "esig", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String esig,
        @WebParam(partName = "locationIEN", name = "locationIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String locationIEN,
        @WebParam(partName = "orderIEN", name = "orderIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String orderIEN,
        @WebParam(partName = "startDate", name = "startDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String startDate
    );

    /**
     * Get unsigned note metadata from all connected VistAs
     */
    @WebResult(name = "TaggedNoteArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedNoteArrays getUnsignedNotes(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nNotes", name = "nNotes", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nNotes
    );

    /**
     * Get patient's IDs from the session's base connection (i.e. from your local site/authenticated site)
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getCorrespondingIds(
        @WebParam(partName = "sitecode", name = "sitecode", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String sitecode,
        @WebParam(partName = "patientId", name = "patientId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String patientId,
        @WebParam(partName = "idType", name = "idType", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String idType
    );

    /**
     * Get a list of lab tests for subsequent call to get test description
     */
    @WebResult(name = "TaggedLabTestArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedLabTestArrays getLabTests(
        @WebParam(partName = "target", name = "target", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String target
    );

    /**
     * Sign a note.
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO signNote(
        @WebParam(partName = "noteIEN", name = "noteIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String noteIEN,
        @WebParam(partName = "userDUZ", name = "userDUZ", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String userDUZ,
        @WebParam(partName = "esig", name = "esig", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String esig
    );

    /**
     * Retrieves the results of a Mental Health Instrument given a Survey Name
     */
    @WebResult(name = "TaggedMentalHealthResultSetArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedMentalHealthResultSetArray getMentalHealthInstrumentResultSetBySurvey(
        @WebParam(partName = "siteCode", name = "siteCode", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String siteCode,
        @WebParam(partName = "surveyName", name = "surveyName", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String surveyName
    );

    /**
     * Get non-VA medications from all connected VistAs
     */
    @WebResult(name = "TaggedMedicationArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedMedicationArrays getOtherMeds();

    /**
     * Get unit dose medications from all connected VistAs
     */
    @WebResult(name = "TaggedMedicationArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedMedicationArrays getUnitDoseMeds();

    /**
     * Get a list of patients by provider
     */
    @WebResult(name = "TaggedPatientArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedPatientArray getPatientsByProvider(
        @WebParam(partName = "duz", name = "duz", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String duz
    );

    /**
     * Get patient's blood bank reports.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getBloodBankReports();

    /**
     * Get a patient's orders
     */
    @WebResult(name = "TaggedOrderArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedOrderArrays getAllOrders();

    /**
     * Get ICD surgery reports from all connected VistAs.
     */
    @WebResult(name = "TaggedIcdRptArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedIcdRptArrays getIcdSurgeryReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Find a patient in the NPT
     */
    @WebResult(name = "PatientArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public PatientArray nptLookup(
        @WebParam(partName = "SSN", name = "SSN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String ssn
    );

    /**
     * Use when switching patient lookup sites.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray visit(
        @WebParam(partName = "pwd", name = "pwd", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String pwd,
        @WebParam(partName = "sitelist", name = "sitelist", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String sitelist,
        @WebParam(partName = "userSitecode", name = "userSitecode", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String userSitecode,
        @WebParam(partName = "userName", name = "userName", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String userName,
        @WebParam(partName = "DUZ", name = "DUZ", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String duz,
        @WebParam(partName = "SSN", name = "SSN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String ssn,
        @WebParam(partName = "context", name = "context", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String context
    );

    /**
     * Get allergies from all connected VistAs
     */
    @WebResult(name = "TaggedAllergyArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedAllergyArrays getAllergies();

    /**
     * Log onto a single VistA system
     */
    @WebResult(name = "UserTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public UserTO login(
        @WebParam(partName = "username", name = "username", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String username,
        @WebParam(partName = "pwd", name = "pwd", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String pwd,
        @WebParam(partName = "context", name = "context", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String context
    );

    /**
     * Lookup a CPRS-enabled user
     */
    @WebResult(name = "UserArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public UserArray cprsUserLookup(
        @WebParam(partName = "target", name = "target", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String target
    );

    /**
     * Add a data source for this session
     */
    @WebResult(name = "SiteTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public SiteTO addDataSource(
        @WebParam(partName = "id", name = "id", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String id,
        @WebParam(partName = "name", name = "name", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String name,
        @WebParam(partName = "datasource", name = "datasource", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String datasource,
        @WebParam(partName = "port", name = "port", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String port,
        @WebParam(partName = "modality", name = "modality", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String modality,
        @WebParam(partName = "protocol", name = "protocol", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String protocol,
        @WebParam(partName = "region", name = "region", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String region
    );

    /**
     * Get patient's chem/hem lab results.
     */
    @WebResult(name = "TaggedChemHemRptArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedChemHemRptArrays getChemHemReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get radiology reports from all connected VistAs
     */
    @WebResult(name = "TaggedRadiologyReportArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedRadiologyReportArrays getRadiologyReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    @WebResult(name = "BoolTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public BoolTO userHasPermission(
        @WebParam(partName = "uid", name = "uid", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String uid,
        @WebParam(partName = "permissionName", name = "permissionName", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String permissionName
    );

    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getUsersWithOption(
        @WebParam(partName = "optionName", name = "optionName", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String optionName
    );

    /**
     * Get surgery reports for a specific site
     */
    @WebResult(name = "TaggedSurgeryReportArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedSurgeryReportArrays getSurgeryReportsBySite(
        @WebParam(partName = "siteCode", name = "siteCode", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String siteCode
    );

    /**
     * Select a patient at logged in site. DFN is the IEN of the patient
     */
    @WebResult(name = "PatientTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public PatientTO select(
        @WebParam(partName = "DFN", name = "DFN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String dfn
    );

    /**
     * Get lab test description text
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getLabTestDescription(
        @WebParam(partName = "identifierString", name = "identifierString", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String identifierString
    );

    /**
     * Get a list of hospital clinics
     */
    @WebResult(name = "TaggedHospitalLocationArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedHospitalLocationArray getClinics(
        @WebParam(partName = "target", name = "target", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String target
    );

    /**
     * Get Username or Hosital Location
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO getUsernameOrHospitalLocation(
        @WebParam(partName = "duz", name = "duz", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String duz,
        @WebParam(partName = "fileNum", name = "fileNum", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fileNum
    );

    /**
     * Get allergies from a specific VistA
     */
    @WebResult(name = "TaggedAllergyArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedAllergyArrays getAllergiesBySite(
        @WebParam(partName = "siteCode", name = "siteCode", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String siteCode
    );

    @WebResult(name = "TaggedHospitalLocationArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedHospitalLocationArray getHospitalLocations(
        @WebParam(partName = "target", name = "target", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String target,
        @WebParam(partName = "direction", name = "direction", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String direction
    );

    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getNoteTitles(
        @WebParam(partName = "target", name = "target", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String target,
        @WebParam(partName = "direction", name = "direction", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String direction
    );

    /**
     * Get admission summaries from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getAdmissionsReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Disconnect from remote Vista systems.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray disconnectRemoteSites();

    /**
     * Get patient's surgical pathology lab results.
     */
    @WebResult(name = "TaggedSurgicalPathologyRptArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedSurgicalPathologyRptArrays getSurgicalPathologyReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getActiveReminderReports();

    /**
     * Get patient's chem/hem lab results. Use 0 for number of results to retrieve all results for the time period.
     */
    @WebResult(name = "TaggedChemHemRptArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedChemHemRptArrays getChemHemReportsSimple(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get all medications from all connected VistAs
     */
    @WebResult(name = "TaggedMedicationArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedMedicationArrays getAllMeds();

    /**
     * Get surgery reports from all connected VistAs
     */
    @WebResult(name = "TaggedSurgeryReportArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedSurgeryReportArrays getSurgeryReportsWithText();

    /**
     * Get outpatient encounters from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getOutpatientEncounterReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get patient's advance directives.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getAdvanceDirectives(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get discharge diagnosis from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getDischargeDiagnosisReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get lexicon lookup for diagnosis and procedure codes<ul><li>lexSearch (required) = search parameter passed by user input (must be at least 3 characters)</li><li>lexApplication (required) = application passed by user (ICD for Diagnosis or CPT for Procedure)</li><li>date is the date/time of the visit relevant to the request, but may be omitted</li></ul>
     */
    @WebResult(name = "TaggedLexiconEntryArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedLexiconEntryArray getLexiconEntries(
        @WebParam(partName = "lexSearch", name = "lexSearch", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String lexSearch,
        @WebParam(partName = "lexApplication", name = "lexApplication", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String lexApplication,
        @WebParam(partName = "date", name = "date", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String date
    );

    /**
     * Get patient's meds administation history.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getMedsAdminHx(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get ADT reports from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getExpandedAdtReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Find a patient in the MPI
     */
    @WebResult(name = "PatientArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public PatientArray mpiLookup(
        @WebParam(partName = "SSN", name = "SSN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String ssn
    );

    /**
     * Get patient's microbiology lab results.
     */
    @WebResult(name = "TaggedMicrobiologyRptArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedMicrobiologyRptArrays getMicrobiologyReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Get selected patient's visits
     */
    @WebResult(name = "TaggedVisitArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedVisitArray getVisits(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate
    );

    /**
     * Get patient's current consults.
     */
    @WebResult(name = "TaggedConsultArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedConsultArrays getConsultsForPatient();

    /**
     * Get a list of patients by clinic
     */
    @WebResult(name = "TaggedPatientArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedPatientArray getPatientsByClinic(
        @WebParam(partName = "clinicId", name = "clinicId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String clinicId
    );

    /**
     * Issue patient confidentiality bulletin to all connected sites.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray issueConfidentialityBulletin();

    /**
     * Get patient's health summary by display name from all connected VistAs.
     */
    @WebResult(name = "TaggedHealthSummaryArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedHealthSummaryArray getHealthSummary(
        @WebParam(partName = "healthSummaryId", name = "healthSummaryId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String healthSummaryId,
        @WebParam(partName = "healthSummaryName", name = "healthSummaryName", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String healthSummaryName
    );

    /**
     * Get patient's mental health appointments.
     */
    @WebResult(name = "TaggedAppointmentArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedAppointmentArrays getMentalHealthAppointments();

    /**
     * Get patient's outpatient prescription profile.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getOutpatientRxProfile();

    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getOrderDialogsForDisplayGroup(
        @WebParam(partName = "displayGroupId", name = "displayGroupId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String displayGroupId
    );

    /**
     * Connect to a single VistA system
     */
    @WebResult(name = "DataSourceArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public DataSourceArray connect(
        @WebParam(partName = "sitelist", name = "sitelist", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String sitelist
    );

    /**
     * Get medication detail from a single connected VistA.
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO getMedicationDetail(
        @WebParam(partName = "siteId", name = "siteId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String siteId,
        @WebParam(partName = "medId", name = "medId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String medId
    );

    /**
     * Get transfer reports from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getTransfersReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Close a note.
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO closeNote(
        @WebParam(partName = "noteIEN", name = "noteIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String noteIEN,
        @WebParam(partName = "consultIEN", name = "consultIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String consultIEN
    );

    /**
     * Setup patient's remote sites for querying.
     */
    @WebResult(name = "SiteArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public SiteArray setupMultiSiteQuery(
        @WebParam(partName = "appPwd", name = "appPwd", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String appPwd
    );

    /**
     * Get all VHA sites
     */
    @WebResult(name = "RegionArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public RegionArray getVHA();

    @WebResult(name = "OrderDialogItemArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public OrderDialogItemArray getOrderDialogItems(
        @WebParam(partName = "dialogId", name = "dialogId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String dialogId
    );

    /**
     * Retrieves the results of a Mental Health Instrument given an administrationId
     */
    @WebResult(name = "MentalHealthInstrumentResultSetTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public MentalHealthInstrumentResultSetTO getMentalHealthInstrumentResultSet(
        @WebParam(partName = "sitecode", name = "sitecode", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String sitecode,
        @WebParam(partName = "administrationId", name = "administrationId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String administrationId
    );

    /**
     * Get latest vitals from all connected VistAs
     */
    @WebResult(name = "TaggedVitalSignArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedVitalSignArrays getLatestVitalSigns();

    /**
     * Get a VistA timestamp
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getVistaTimestamps();

    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getSitesForStation();

    /**
     * Get patient's mental health appointments.
     */
    @WebResult(name = "TaggedVisitArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedVisitArrays getMentalHealthVisits();

    /**
     * Get patient's crisis notes.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getCrisisNotes(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Make a patient inquiry call (address, contact numbers, NOK, etc. information)
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO patientInquiry();

    /**
     * Get C&P reports from all connected VistAs.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getCompAndPenReports(
        @WebParam(partName = "fromDate", name = "fromDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String fromDate,
        @WebParam(partName = "toDate", name = "toDate", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String toDate,
        @WebParam(partName = "nrpts", name = "nrpts", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String nrpts
    );

    /**
     * Match patients at logged in site. Accepts: SSN, 'LAST,FIRST', A1234 (Last name initial + last four SSN)
     */
    @WebResult(name = "TaggedPatientArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedPatientArrays match(
        @WebParam(partName = "target", name = "target", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String target
    );

    /**
     * Get problems from all connected sites
     */
    @WebResult(name = "TaggedProblemArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedProblemArrays getProblemsFromSites(
        @WebParam(partName = "status", name = "status", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String status
    );

    @WebResult(name = "ReminderReportPatientListTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public ReminderReportPatientListTO getPatientListForReminderReport(
        @WebParam(partName = "rptId", name = "rptId", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String rptId
    );

    /**
     * Get details of the patient's current admission.
     */
    @WebResult(name = "AdmissionTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public AdmissionTO getCurrentAdmissionDetails();

    /**
     * Get patient confidentiality from all connected sites.
     */
    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getConfidentiality();

    @WebResult(name = "TaggedTextArray", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedTextArray getOrderableItemsByName(
        @WebParam(partName = "name", name = "name", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String name
    );

    /**
     * Is       er required for this user/author pair?
     */
    @WebResult(name = "TextTO", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TextTO isCosignerRequired(
        @WebParam(partName = "noteDefinitionIEN", name = "noteDefinitionIEN", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String noteDefinitionIEN,
        @WebParam(partName = "authorDUZ", name = "authorDUZ", targetNamespace = "http://mdws.domain/EmrSvc")
        java.lang.String authorDUZ
    );

    /**
     * Get patient's vital signs.
     */
    @WebResult(name = "TaggedVitalSignSetArrays", targetNamespace = "http://mdws.domain/EmrSvc", partName = "Body")
    @WebMethod
    public TaggedVitalSignSetArrays getVitalSigns();
}
