package com.agilex.healthcare.mobilehealthplatform.mdws.connection;

public class EmrConnectionManagerFactory {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(EmrConnectionManagerFactory.class);

	private static EmrConnectionManager connectionManager;
	private static PoolConfiguration poolConfiguration;

	private EmrConnectionManagerFactory() {}

	public static EmrConnectionManager getInstance() {
		if (connectionManager != null)
			return connectionManager;

		if (poolConfiguration == null)
			getConfiguration();

//		if (poolConfiguration.isPooled()){
//			logger.debug("Initializing pooled connection manager for MDWS EmrSvc");
//			connectionManager = new PooledEmrConnectionManager(poolConfiguration);
//		} else {
//			logger.debug("Initializing basic connection manager for MDWS EmrSvc");
//			connectionManager = new BasicEmrConnectionManager();
//		}
		
		connectionManager = new BasicEmrConnectionManager();
		
		return connectionManager;
	}

	private static PoolConfiguration getConfiguration() {
		if (poolConfiguration == null) {
			logger.debug("Loading connection pool configuration");
			poolConfiguration = new PoolConfiguration();
			poolConfiguration.load();
		}
		return poolConfiguration;
	}

	// Used for testing
	static void setConfiguration(PoolConfiguration configuration) {
		poolConfiguration = configuration;
	}
}
