package com.agilex.healthcare.mobilehealthplatform.mdws.connection;


public class ConnectionObjectPool {

//	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ConnectionObjectPool.class);
//
//	int defaultPoolSize = 0;
//	int maximumPoolSize = 10;
//	private ConnectionPoolConfiguration poolConfiguration;
//	private EmrSoapPortFactory connectionPoolFactory;
//	
//	private Map<String, List<EmrSoapPort>> connectionPool = new ConcurrentHashMap<String, List<EmrSoapPort>>();
//	private Map<String, List<EmrSoapPort>> authenticatedPool = new ConcurrentHashMap<String, List<EmrSoapPort>>();
//
//	public ConnectionObjectPool(ConnectionPoolConfiguration poolConfiguration) {
//		this.poolConfiguration = poolConfiguration;
//		this.defaultPoolSize = poolConfiguration.getMinimumPoolSize();
//		this.maximumPoolSize = poolConfiguration.getMaxPoolSize();
//		this.connectionPoolFactory = EmrSoapPortFactory.getInstance();
//		
//		List<String> sites = parseSites(poolConfiguration.getSiteCodes());
//		initializeSiteCollections(sites);
//		initializeSites(sites);
//	}
//
//	void initializeSiteCollections(List<String> sites) {
//		for(String site : sites) {
//			List<EmrSoapPort> connectionPorts = new ArrayList<EmrSoapPort>();
//			List<EmrSoapPort> authenticatedPorts = new ArrayList<EmrSoapPort>();
//			
//			connectionPool.put(site, connectionPorts);
//			authenticatedPool.put(site, authenticatedPorts);
//		}
//	}
//	
//	public synchronized EmrSoapPort borrowConnection(MdwsConfiguration configuration, boolean authenticated) {
//		List<EmrSoapPort> connections;
//		if (authenticated)
//			connections = authenticatedPool.get(configuration.getSiteCode());
//		else
//			connections = connectionPool.get(configuration.getSiteCode());
//
//		EmrSoapPort borrowedPort;
//		if (connections == null || connections.size() == 0) {
//			initializeSiteCollections(Arrays.asList(configuration.getSiteCode())); // when the port gets returned, we now have a place to store it
//			borrowedPort = new EmrSoapPort(configuration, authenticated);
//			borrowedPort.borrow();
//			
//			logger.info(String.format("[EXPENSIVE] Initializing a new connection; Connection Pool is empty for [site: %s]; ", configuration.getSiteCode()));
//		} else {
//			borrowedPort = connections.get(0);
//			borrowedPort.borrow();
//			connections.remove(borrowedPort);
//		}
//		
//		return borrowedPort;
//	}
//
//	public synchronized void returnConnection(MdwsConfiguration configuration, EmrSoapPort connection, boolean authenticated) {
//		if (authenticated) {
//			returnAuthenticatedConnectionToPoolIfCriteriaMet(connection);
//		} else {
//			returnAndPassivateUnauthenticatedConnection(connection);
//		}
//	}
//	
//	private void returnAuthenticatedConnectionToPoolIfCriteriaMet(EmrSoapPort connection) {
//		List<EmrSoapPort> connections = authenticatedPool.get(connection.getConfiguration().getSiteCode());
//		if(connections.size() < maximumPoolSize){
//			connection.release();
//			connections.add(connection);
//		} else {
//			connectionPoolFactory.destroyConnection(connection, connections);
//		}
//	}
//	
//	/*
//	 * should only need to passivate "unauthenticated" connections that are making queries outside
//	 * of our system account. these could be logging in as other users (and emr has no logout / reset)
//	 *
//	 */
//	private void returnAndPassivateUnauthenticatedConnection(EmrSoapPort connection) {
//		connection.release();
//		List<EmrSoapPort> connections = connectionPool.get(connection.getConfiguration().getSiteCode());
//		if(connections.size() < maximumPoolSize) 
//			connectionPoolFactory.passivateConnection(connection, connections);
//		else
//			connectionPoolFactory.destroyConnection(connection, connections);
//	}
//
//	private void initializeSites(List<String> sites) {
//		MdwsConfiguration mdwsConfiguration = new MdwsConfiguration(poolConfiguration.getEndPointUrl(), 
//				poolConfiguration.getServiceAccessCode(), poolConfiguration.getServiceVerifyCode(), null);
//		
//		for (String site : sites) {
//			mdwsConfiguration.setSiteCode(site);
//			for (int i = 0; i < this.defaultPoolSize; i++) {
//				addAuthenticatedConnectionToPool(mdwsConfiguration);
//				addUnauthenticatedConnectionToPool(mdwsConfiguration);
//			}
//		}
//	}
//	
//	void addUnauthenticatedConnectionToPool(MdwsConfiguration mdwsConfiguration) {
//		List<EmrSoapPort> connections = connectionPool.get(mdwsConfiguration.getSiteCode());
//		connectionPoolFactory.makeConnection(mdwsConfiguration, connections, false);
//	}
//	
//	void addAuthenticatedConnectionToPool(MdwsConfiguration mdwsConfiguration) {
//		List<EmrSoapPort> connections = authenticatedPool.get(mdwsConfiguration.getSiteCode());
//		connectionPoolFactory.makeConnection(mdwsConfiguration, connections, true);
//	}
//
//	public void disconnectAll() {
//		disconnectSites(connectionPool);
//		disconnectSites(authenticatedPool);
//		
//		connectionPool = new ConcurrentHashMap<String, List<EmrSoapPort>>();
//		authenticatedPool = new ConcurrentHashMap<String, List<EmrSoapPort>>();
//	}
//
//	private void disconnectSites(Map<String, List<EmrSoapPort>> ports) {
//		Set<String> keys = ports.keySet();
//		for(String key : keys) {
//			disconnect(ports.get(key));
//		}
//	}
//	
//	private void disconnect(List<EmrSoapPort> connectedPorts) {
//		for (EmrSoapPort connectedPort : connectedPorts) {
//			connectedPort.getPort().disconnect();
//		}
//	}
//
//	private List<String> parseSites(String commaSeparatedSites) {
//		String[] splitSites = commaSeparatedSites.trim().split(",");
//		
//		List<String> siteCodes = new ArrayList<String>();
//		if (commaSeparatedSites != null) {
//			for(String site : splitSites) {
//				siteCodes.add(site.trim());
//			}
//		}
//		return siteCodes;
//	}
//	
//	Map<String, List<EmrSoapPort>> getConnectionPool() {
//		return this.connectionPool;
//	}
//	
//	Map<String, List<EmrSoapPort>> getAuthenticatedPool() {
//		return this.authenticatedPool;
//	}
//
//	public void setPoolSize(int poolSize) {
//		this.defaultPoolSize = poolSize;
//	}
//
//	public int getPoolSize() {
//		return this.defaultPoolSize;
//	}
}
