package com.agilex.healthcare.mobilehealthplatform.mdws.connection;

import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

public class BasicEmrConnectionManager implements EmrConnectionManager {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(BasicEmrConnectionManager.class);

	@Override
	public EmrConnection getSiteConnection(MdwsConfiguration mdwsConfiguration, String siteCode) {
		logger.debug("requesting unauthenticated port using a basic connection manager");
		return new EmrConnection(mdwsConfiguration, siteCode, false);
	}

	@Override
	public EmrConnection getAuthenticatedSiteConnection(MdwsConfiguration mdwsConfiguration, String siteCode) {
		logger.debug("requesting authenticated port using a basic connection manager with site type and site code.");
		return new EmrConnection(mdwsConfiguration, siteCode, true);
	}

}
