package com.agilex.healthcare.mobilehealthplatform.mdws;


/**
 * This class is meant to be used to construct custom messages for the end user based on values returned from MDWS.
 */
public class MdwsResponseFaultTOFilter {
	public static MdwsResponseException.UserMessages getResponseType(String msg) {
		MdwsResponseException.UserMessages retValue = MdwsResponseException.UserMessages.GENERIC_ERROR;
		
		if (msg.contains("Missing local PID") || msg.contains("Patient is unknown to CPRS"))
			retValue = MdwsResponseException.UserMessages.INVALID_PATIENT;
		else if (msg.contains("Invalid person name"))
			retValue = MdwsResponseException.UserMessages.INVALID_SEARCH_CRITERIA;
		
		else if (msg.contains("Timeout waiting for response"))
			retValue = MdwsResponseException.UserMessages.TIMEOUT;
		
		else if (msg.contains("Connections not ready for operation") || msg.contains("There is no logged in connection"))
			retValue = MdwsResponseException.UserMessages.CONNECTIONS_NOT_READY;
		
		else if (msg.contains("Could not send Message.") || msg.contains("Index and length must refer to a location within the string"))
			retValue = MdwsResponseException.UserMessages.CONNECTION_ERROR;
		
		else if (msg.contains("Unmarshalling Error"))
			retValue = MdwsResponseException.UserMessages.INVALID_WSDL;
		
		return retValue;
	}

	public static MdwsResponseException.UserMessages filterFault(com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.FaultTO fault) {
		String msg = fault.getMessage();
		MdwsResponseException.UserMessages retValue = getResponseType(msg);
		return retValue;
	}

	public static MdwsResponseException.UserMessages filterFault(com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.FaultTO fault) {
		String msg = fault.getMessage();
		MdwsResponseException.UserMessages retValue = getResponseType(msg);
		return retValue;
	}
}
