package com.agilex.healthcare.mobilehealthplatform.mdws;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfigurationHelper;
import java.util.concurrent.atomic.AtomicBoolean;

public class MdwsEmrDataLayer {

	protected final MdwsConfiguration mdwsConfiguration;
	private final AtomicBoolean isConnectedToCDW = new AtomicBoolean(false);
	
	protected MdwsEmrDataLayer(MdwsConfiguration mdwsConfiguration) {
		this.mdwsConfiguration = mdwsConfiguration;
	}

	protected EmrConnection getAuthenticatedConnection(String siteCode) {
		EmrConnectionManager connectionManager = EmrConnectionManagerFactory.getInstance();
		EmrConnection connection = connectionManager.getAuthenticatedSiteConnection(mdwsConfiguration, siteCode);
		boolean connectedToCDW = (siteCode.equals(MdwsConfigurationHelper.CDW_SITECODE));
		isConnectedToCDW.set(connectedToCDW);
		
		return connection;
	}
	
	protected void disconnectFromCdwIfApplicable(EmrConnection emrConnection) {
		if (isConnectedToCDW.get() == true){
			emrConnection.disconnect();
			isConnectedToCDW.compareAndSet(true, false);
		}
	}

	protected EmrConnection getAuthenticatedConnectionWithPatientSelect(PatientIdentifier patientIdentifier) {
		EmrConnection connection = getAuthenticatedConnection(getSiteCodeFromPatientIdentifier(patientIdentifier));
		connection.getPort().select(patientIdentifier.getUniqueId());
		return connection;
	}

    protected String getSiteCodeFromPatientIdentifier(PatientIdentifier patientIdentifier){
		String siteCode = new MdwsConfigurationHelper().extractSiteCodeFromAssigningAuthority(patientIdentifier.getAssigningAuthority());
		return siteCode;
	}
}
