package com.agilex.healthcare.mobilehealthplatform.mdws;

import java.util.Date;

import com.agilex.healthcare.utility.DateHelper;

public class MdwsDateTranslationUtil {
	
	private static String VA_DEFAULT_START_DATE_CDW_FORMAT = "01/01/1990";
	private static String VA_DEFAULT_START_DATE_VISTA_FORMAT = "19900101.000000";

	public String dateFormatBySystem(Date date, String system) {
		if (system.equalsIgnoreCase(MdwsDataSourceCode.VISTA))
			return DateHelper.formatDateTimeInVistaFormat(date);

		return DateHelper.formatDate(date);
	}

	public Date extractDateOrNull(String date) {
		Date parsedDate = parseVistaDate(date);
		if(parsedDate == null)
			parsedDate = parseVistaDateTime(date);
		if(parsedDate == null)
			parsedDate = parseCdwDate(date);
		if (parsedDate == null)
			parsedDate = parseCdwDateTime(date);
		
		return parsedDate;
	}

	public String startDateBySystem(Date date, String system) {
		if(MdwsDataSourceCode.VISTA.equalsIgnoreCase(system)) 
			return startDateInVistaFormat(date);
	
		return startDateInCdwFormat(date);
	}
	 
	public String endDateBySystem(Date date, String system) {
		if(MdwsDataSourceCode.VISTA.equalsIgnoreCase(system))
			return endDateInVistaFormat(date);
		
		return endDateInCdwFormat(date);
	}
	
	public String startDateInCdwFormat(Date date) {
		if(date == null)
			return VA_DEFAULT_START_DATE_CDW_FORMAT;
		
		return DateHelper.formatDate(date);
	}
	
	public String startDateInVistaFormat(Date date) {
		if(date == null) 
			return VA_DEFAULT_START_DATE_VISTA_FORMAT;
		
		return DateHelper.formatDateTimeInVistaFormat(date);
	}
	
	public String endDateInCdwFormat(Date date) {
		if(date == null)
			date = new Date();
		
		return DateHelper.formatDate(date);
	}
	
	public String endDateInVistaFormat(Date date) {
		if(date == null)
			date = new Date();
		
		return DateHelper.formatDateTimeInVistaFormat(date);
	}

	private Date parseVistaDate(String date) {
		try {
			return DateHelper.parseVistaDate(date);
		} catch (RuntimeException e) {
			// If we can't parse this format, return null
		}

		return null;
	}
	
	private Date parseVistaDateTime(String date) {
		try {
			return DateHelper.parseVistaDateTimeOrNull(date);
		} catch (RuntimeException e) {
			// If we can't parse this format, return null
		}
		
		return null;
	}

	private Date parseCdwDateTime(String date) {
		try {
			return DateHelper.parseDateTime(date);
		} catch (RuntimeException e) {
			// If we can't parse this format, return null
		}

		return null;
	}
	
	private Date parseCdwDate(String date) {
		try {
			return DateHelper.parseDate(date);
		} catch (RuntimeException e) {
		}

		return null;
	}
}
