package com.agilex.healthcare.mobilehealthplatform.mdws;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.PatientTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfigurationHelper;

public class CdwRawPatientDataLayer<T extends PatientData, Ts extends PatientDataCollection<T>> extends CdwDataLayer{

    public CdwRawPatientDataLayer (MdwsConfiguration mdwsConfiguration){
        super(mdwsConfiguration, MdwsConfigurationHelper.CDW_RAW_SITECODE);
    }

    protected EmrConnection getAuthenticatedConnectionWithPatientSelect(String patientId) {
        EmrConnection emrConnection = super.establishCdwConnection();
        PatientTO result = emrConnection.getPort().select(patientId);
        if (result.getFault() != null) {
            throw new MdwsResponseException(MdwsResponseException.UserMessages.INVALID_PATIENT, result.getFault());
        }
        return emrConnection;
    }

    protected String getSiteCodeFromPatientIdentifier(PatientIdentifier patientIdentifier){
        String siteCode = new MdwsConfigurationHelper().extractSiteCodeFromAssigningAuthority(patientIdentifier.getAssigningAuthority());
        return siteCode;
    }

    protected Ts setIdentifiers(Ts ts, PatientIdentifier originalIdentifier, String system) {
        for (T t : ts) {
            t.setPatientIdentifier(originalIdentifier);
            t.setSystemId(system);
        }

        return ts;
    }

    protected T setIdentifiers(T t, PatientIdentifier originalIdentifier, String system) {
        t.setPatientIdentifier(originalIdentifier);
        t.setSystemId(system);

        return t;
    }

}
