package com.agilex.healthcare.mobilehealthplatform.mdws;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientData;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.utility.PatientIdentityHelper;

public class CdwPatientDataLayer<T extends PatientData, Ts extends PatientDataCollection<T>> extends CdwDataLayer{
	
	public CdwPatientDataLayer(MdwsConfiguration mdwsConfiguration){
		super(mdwsConfiguration);
	}
	
	protected Ts setIdentifiers(Ts ts, PatientIdentifier originalIdentifier, String system) {
		for (T t : ts) {
			t.setPatientIdentifier(originalIdentifier);
			t.setSystemId(system);
		}

		return ts;
	}

	protected T setIdentifiers(T t, PatientIdentifier originalIdentifier, String system) {
		t.setPatientIdentifier(originalIdentifier);
		t.setSystemId(system);

		return t;
	}

	protected PatientIdentifier alterForCdw(PatientIdentifier patientIdentifier) {
		PatientIdentityHelper helper = new PatientIdentityHelper();
		return helper.truncateICN(patientIdentifier);
	}
	
}
