package com.agilex.healthcare.mobilehealthplatform.mdws;

import com.agilex.healthcare.mobilehealthplatform.mdws.connection.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfigurationHelper;

public class CdwDataLayer {

    private final MdwsConfiguration mdwsConfiguration;
    private String siteCode = MdwsConfigurationHelper.CDW_SITECODE;

    public CdwDataLayer (MdwsConfiguration mdwsConfiguration){
        this.mdwsConfiguration = mdwsConfiguration;
    }

    public CdwDataLayer (MdwsConfiguration mdwsConfiguration, String siteCode){
        this.mdwsConfiguration = mdwsConfiguration;
        this.siteCode = siteCode;
    }

    protected EmrConnection establishCdwConnection() {
        EmrConnectionManager connectionManager = EmrConnectionManagerFactory.getInstance();
        return connectionManager.getAuthenticatedSiteConnection(mdwsConfiguration, siteCode);
    }

    protected void returnConnection(EmrConnection connection) {
        connection.disconnect();
    }

    protected MdwsConfiguration getMdwsConfiguration() {
        return mdwsConfiguration;
    }

}
