package com.agilex.healthcare.mobilehealthplatform.datalayer.vital;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsEmrDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseValidator;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedVitalSignArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedVitalSignSetArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfigurationHelper;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.VitalsTranslator;
import com.agilex.healthcare.utility.NullSafeStringComparer;
 
public class VitalDataLayerMdws extends MdwsEmrDataLayer implements VitalDataLayer {
	
	public VitalDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}
	
	@Override
	public VitalEntries fetchVitalEntries(PatientIdentifier patientIdentifier, VitalEntryFilter filter) {
		VitalEntries vitalEntries = fetchVitalEntries(patientIdentifier);
		
		return filter(vitalEntries, filter);
	}

	@Override
	public VitalEntry fetchVitalEntry(PatientIdentifier patientIdentifier, String vitalId) {
		VitalEntries vitalEntries = fetchVitalEntries(patientIdentifier);
		
		for(VitalEntry vitalEntry : vitalEntries) {
			if(NullSafeStringComparer.areEqual(vitalEntry.getUniqueId(), vitalId)) {
				return vitalEntry;
			}
		}
		
		return null;
	}
	
	// Used by CDW
	public VitalEntries getLatestVitalEntries(PatientIdentifier patientIdentifier, VitalEntryFilter filter) {
		
		EmrConnection connection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);
		TaggedVitalSignArrays latestVitalSigns = connection.getPort().getLatestVitalSigns();
		super.disconnectFromCdwIfApplicable(connection);
		
		MdwsResponseValidator.validateMdwsObject(latestVitalSigns);
		VitalEntries translated = translateArrays(latestVitalSigns);
		
		String siteType = new MdwsConfigurationHelper().extractSiteTypeFromAssigningAuthority(patientIdentifier.getAssigningAuthority());
		correctIdentifiers(translated, siteType);
		
		return filter(translated, filter);
	}

	@Deprecated
	@Override
	public VitalEntries getVitalEntries(String patientId, VitalEntryFilter filter) {
		VitalEntries vitalEntries = fetchVitalEntries(patientId);
		
		return filter(vitalEntries, filter);
	}

	@Deprecated
	@Override
	public VitalEntry getVitalEntry(String patientId, String vitalId) {
		VitalEntries vitalEntries = fetchVitalEntries(patientId);
		
		for(VitalEntry vitalEntry : vitalEntries) {
			if(NullSafeStringComparer.areEqual(vitalEntry.getUniqueId(), vitalId)) {
				return vitalEntry;
			}
		}
		
		return null;
	}
	
	private VitalEntries fetchVitalEntries(String patientId) {
		throw new UnsupportedOperationException();
	}
	
	private VitalEntries fetchVitalEntries(PatientIdentifier patientIdentifier) {
		
		EmrConnection connection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);
		TaggedVitalSignSetArrays vitalSigns = connection.getPort().getVitalSigns();
		super.disconnectFromCdwIfApplicable(connection);
		
		MdwsResponseValidator.validateMdwsObject(vitalSigns);
		VitalEntries translated = translateSets(vitalSigns);
		
		String siteType = new MdwsConfigurationHelper().extractSiteTypeFromAssigningAuthority(patientIdentifier.getAssigningAuthority());
		correctIdentifiers(translated, siteType);
		
		return translated;
	}
	
	private VitalEntries translateSets(TaggedVitalSignSetArrays vitalSigns) {
		VitalsTranslator translator = new VitalsTranslator();
		return translator.translateSets(vitalSigns);
	}
	
	private VitalEntries translateArrays(TaggedVitalSignArrays arrays) {
		VitalsTranslator translator = new VitalsTranslator();
		return translator.translateArrays(arrays);
	}
	
	private void correctIdentifiers(VitalEntries vitalEntries, String system) {
		for(VitalEntry vitalEntry : vitalEntries) {
			vitalEntry.setSystemId(system);
		}
	}
	
	private VitalEntries filter(VitalEntries vitalEntries, VitalEntryFilter filter) {
		return VitalDataLayerFilterer.applyFilter(vitalEntries, filter);
	}

	////
	@Override
	public VitalEntry saveVitalEntry(VitalEntry vitalEntry) {
		throw new UnsupportedOperationException("This method is not currently supported for provider-entered vitals");
	}

	@Override
	public void deleteVitalEntry(VitalEntry vitalEntry) {
		throw new UnsupportedOperationException("This method is not currently supported for provider-entered vitals");
	}

	
	
}
