package com.agilex.healthcare.mobilehealthplatform.datalayer.vital;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.mdws.CdwPatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

public class VitalDataLayerCdw extends CdwPatientDataLayer<VitalEntry, VitalEntries> implements VitalDataLayer {

	VitalDataLayerMdws dataLayer;

	public VitalDataLayerCdw(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
		dataLayer = new VitalDataLayerMdws(mdwsConfiguration);
	}

	@Override
	public VitalEntry saveVitalEntry(VitalEntry vitalEntry) {
		throw new UnsupportedOperationException("This method is not currently supported for provider-entered vitals");
	}

	@Override
	public void deleteVitalEntry(VitalEntry vitalEntry) {
		throw new UnsupportedOperationException("This method is not currently supported for provider-entered vitals");
	}

	@Override
	public VitalEntries fetchVitalEntries(PatientIdentifier patientIdentifier, VitalEntryFilter filter) {
		VitalEntries vitalEntries = dataLayer.getLatestVitalEntries(alterForCdw(patientIdentifier), filter);

		return setIdentifiers(vitalEntries, patientIdentifier, SourceSystemCode.CDW);
	}

	@Override
	public VitalEntry fetchVitalEntry(PatientIdentifier patientIdentifier, String vitalId) {
		VitalEntry vitalEntry = dataLayer.fetchVitalEntry(patientIdentifier, vitalId);

		return setIdentifiers(vitalEntry, patientIdentifier, SourceSystemCode.CDW);
	}

	@Override
	public VitalEntries getVitalEntries(String patientId, VitalEntryFilter filter) {
		throw new UnsupportedOperationException();
	}

	@Override
	public VitalEntry getVitalEntry(String patientId, String vitalId) {
		throw new UnsupportedOperationException();
	}
}
