package com.agilex.healthcare.mobilehealthplatform.datalayer.surgery;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedSurgeryReportArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.SurgeryTranslator;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class SurgeryDataLayerMdws extends MdwsEmrDataLayer implements SurgeryDataLayer {

	public SurgeryDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	@Deprecated
	@Override
	public Surgeries getPatientSurgeries(String patientId, DateFilter dateFilter) {
		throw new UnsupportedOperationException();
	}

	private Surgeries translate(TaggedSurgeryReportArrays surgeryReports) {
		SurgeryTranslator translator = new SurgeryTranslator();
		return translator.translate(surgeryReports);
	}

	private Surgeries filter(Surgeries surgeries, DateFilter filter) {
		return DateFilterer.filterByDate(surgeries, filter);
	}

	@Override
	public Surgeries fetchSurgeries(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);

		TaggedSurgeryReportArrays surgeryReports = authenticatedConnection.getPort().getSurgeryReports();
		
		super.disconnectFromCdwIfApplicable(authenticatedConnection);
		MdwsResponseValidator.validateMdwsObject(surgeryReports);
		Surgeries surgeries = translate(surgeryReports);
		
		return filter(surgeries, dateFilter);
	}
	
	@Override
	public Surgery fetchSurgery(PatientIdentifier patientIdentifier, String surgeryId) {
		Surgeries surgeries = fetchSurgeries(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		Surgery match = null;
		for(Surgery surgery : surgeries) {
			if(NullSafeStringComparer.areEqualIgnoreCase(surgery.getUniqueId(), surgeryId)) {
				match = surgery;
				break;
			}
		}
		
		return match;
	}

}
