package com.agilex.healthcare.mobilehealthplatform.datalayer.surgery;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedSurgeryReportArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.SurgeryTranslator;

public class SurgeryDataLayerCdw extends CdwRawPatientDataLayer<Surgery, Surgeries> implements SurgeryDataLayer {

	public SurgeryDataLayerCdw(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	@Override
	public Surgeries fetchSurgeries(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier.getUniqueId());
		String siteCode = super.getSiteCodeFromPatientIdentifier(patientIdentifier);

		TaggedSurgeryReportArrays taggedSurgeryReports = authenticatedConnection.getPort().getSurgeryReportsBySite(siteCode);
		super.returnConnection(authenticatedConnection);
		MdwsResponseValidator.validateMdwsObject(taggedSurgeryReports);
		
		Surgeries surgeries = translateAndFilter(taggedSurgeryReports, dateFilter);
		
		return setIdentifiers(surgeries, patientIdentifier, SourceSystemCode.CDW_RAW);
	}

	@Override
	public Surgery fetchSurgery(PatientIdentifier patientIdentifier, String surgeryId) {
		Surgeries surgeries = fetchSurgeries(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		Surgery match = null;
		for(Surgery surgery : surgeries) {
			if(surgeryId.equalsIgnoreCase(surgery.getUniqueId())) {
				match = surgery;
			}
		}
		
		return match;
	}

	// //

	private Surgeries translateAndFilter(TaggedSurgeryReportArrays surgeryReportArrays, DateFilter dateFilter) {
		SurgeryTranslator translator = new SurgeryTranslator();
		Surgeries translated = translator.translate(surgeryReportArrays);
		return DateFilterer.filterByDate(translated, dateFilter);
	}
	
	@Deprecated
	@Override
	public Surgeries getPatientSurgeries(String patientId, DateFilter dateFilter) {

		return null;
	}
}
