package com.agilex.healthcare.mobilehealthplatform.datalayer.provider;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.ProviderTranslator;

public class ProviderDataLayerMdws extends MdwsEmrDataLayer implements ProviderDataLayer {

	public ProviderDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	/**
	 * This is not implemented in MDWS and is assumed to not be in use 
	 */
	@Override
	public PatientProviders fetchPrimaryCareProviders(PatientIdentifier patientIdentifier, String siteCode) {
//		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);
//
//		PatientCareTeamTO careTeamTo = authenticatedConnection.getPort().getPatientCareTeam(siteCode);
//		super.disconnectFromCdwIfApplicable(authenticatedConnection);
//		MdwsResponseValidator.validateMdwsObject(careTeamTo);
//
//		return translate(careTeamTo);
		throw new UnsupportedOperationException();
	}

	@Override
	public PatientProviders fetchMentalHealthProviders(PatientIdentifier patientIdentifier, DateFilter filter, String facilitySystemCode) {
		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);

		TaggedVisitArrays visitArrays = authenticatedConnection.getPort().getMentalHealthVisits();
		super.disconnectFromCdwIfApplicable(authenticatedConnection);
		MdwsResponseValidator.validateMdwsObject(visitArrays);

		List<VisitTO> filteredList = filterByFacilitySystemCode(getVisitTOList(visitArrays), facilitySystemCode);

		PatientProviders translated = translate(filteredList);
		PatientProviders dateFilteredProviders = filterByDate(translated, filter);
		PatientProviders uniqueProviders = filterOutDuplicates(dateFilteredProviders);

		return uniqueProviders;
	}

	private List<VisitTO> getVisitTOList(TaggedVisitArrays visitArrays) {
		ProviderTranslator translator = new ProviderTranslator();
		return translator.getVisitTOList(visitArrays);
	}

//	private PatientProviders translate(PatientCareTeamTO arrays) {
////		ProviderTranslator translator = new ProviderTranslator();
////		return translator.translate(arrays);
//		return null;
//	}

	private PatientProviders translate(List<VisitTO> visitTOList) {
		ProviderTranslator translator = new ProviderTranslator();
		return translator.translate(visitTOList);
	}

	private List<VisitTO> filterByFacilitySystemCode(List<VisitTO> visitTOList, String facilitySystemCode) {
		List<VisitTO> filteredList = new ArrayList<VisitTO>();

		if (facilitySystemCode == null || facilitySystemCode.equals("")) {
			filteredList.addAll(visitTOList);
		} else {
			String siteCode = "";
			for (VisitTO visitTO : visitTOList) {
				siteCode = visitTO.getFacility().getSitecode();
				if (siteCode.equals(facilitySystemCode)) {
					filteredList.add(visitTO);
				}
			}
		}
		return filteredList;
	}

	private PatientProviders filterOutDuplicates(PatientProviders providers) {
		HashMap<String, PatientProvider> providerHashMap = new HashMap<String, PatientProvider>();

		PatientProviders result = new PatientProviders();

		for (PatientProvider provider : providers) {
			// check if entry already in our dictionary
			String key = getProviderKey(provider);
			if (!providerHashMap.containsKey(key)) {
				// if not, then add
				result.add(provider);
				// then add to dictionary so we don't add again
				providerHashMap.put(key, provider);
			}

		}
		return result;
	}

	private String getProviderKey(PatientProvider provider) {
		return String.format("ProviderName={%1s},ProviderClass={%2s}", provider.getProviderName(), provider.getPersonClass());
	}

	private PatientProviders filterByDate(PatientProviders providers, DateFilter dateFilter) {
		return DateFilterer.filterByDate(providers, dateFilter);
	}

	@Override
	public PatientProviders fetchPrimaryCareProviders(PatientIdentifier patientIdentifier) {
		throw new UnsupportedOperationException();
	}

}
