package com.agilex.healthcare.mobilehealthplatform.datalayer.provider;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProvider;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProviders;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.mdws.CdwPatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

public class ProviderDataLayerCdw extends CdwPatientDataLayer<PatientProvider, PatientProviders> implements ProviderDataLayer {

	ProviderDataLayerMdws dataLayer;

	public ProviderDataLayerCdw(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
		dataLayer = new ProviderDataLayerMdws(mdwsConfiguration);
	}

	@Override
	public PatientProviders fetchMentalHealthProviders(PatientIdentifier patientIdentifier, DateFilter filter, String facilitySystemCode) {
		PatientProviders providers = dataLayer.fetchMentalHealthProviders(alterForCdw(patientIdentifier), filter, facilitySystemCode);
		return setIdentifiers(providers, patientIdentifier, SourceSystemCode.CDW);
	}

	@Override
	public PatientProviders fetchPrimaryCareProviders(PatientIdentifier patientIdentifier, String siteCode) {
		PatientProviders providers = dataLayer.fetchPrimaryCareProviders(alterForCdw(patientIdentifier), siteCode);
		return setIdentifiers(providers, patientIdentifier, SourceSystemCode.CDW);
	}
	
	@Override
	public PatientProviders fetchPrimaryCareProviders(PatientIdentifier patientIdentifier) {
		throw new UnsupportedOperationException();
	}
	
}
