package com.agilex.healthcare.mobilehealthplatform.datalayer.problem;

import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedProblemArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.ProblemTranslator;

public class ProblemDataLayerMdws extends MdwsEmrDataLayer implements ProblemDataLayer {

	public ProblemDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	@Override
	public Problems fetchProblems(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		Problems problems = fetchPatientProblems(patientIdentifier);
		return DateFilterer.filterByDate(problems, dateFilter);
	}
	
	private Problems fetchPatientProblems(PatientIdentifier patientIdentifier) {
		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);
		TaggedProblemArrays taggedProblemArrays = authenticatedConnection.getPort().getProblemList("all");
		super.disconnectFromCdwIfApplicable(authenticatedConnection);
		
		MdwsResponseValidator.validateMdwsObject(taggedProblemArrays);

		return translate(taggedProblemArrays);
	}
	
	private Problems translate(TaggedProblemArrays taggedProblemArrays) {
		ProblemTranslator translator = new ProblemTranslator();
		return translator.translateMdwsTaggedProblemArrays(taggedProblemArrays);
	}

}
