package com.agilex.healthcare.mobilehealthplatform.datalayer.problem;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.mdws.CdwPatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

public class ProblemDataLayerCdw extends CdwPatientDataLayer<Problem, Problems> implements ProblemDataLayer {

	ProblemDataLayerMdws dataLayer;
	
	public ProblemDataLayerCdw(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
		dataLayer = new ProblemDataLayerMdws(mdwsConfiguration);
	}
	
	@Override
	public Problems fetchProblems(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		Problems problems = dataLayer.fetchProblems(alterForCdw(patientIdentifier), dateFilter);
		return setIdentifiers(problems, patientIdentifier, SourceSystemCode.CDW);
	}
}
