package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsEmrDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.DemographicTranslator;

public class PatientSupplementalDemographicsDataLayerMdws extends MdwsEmrDataLayer implements PatientSupplementalDemographicsDataLayer {
	
	public PatientSupplementalDemographicsDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	public PatientDemographics fetchDemographics(PatientIdentifier patientIdentifier) {
		throw new UnsupportedOperationException();
	}
	
	PatientDemographics translate(ArrayOfDemographicSetTO arrayOfDemographics) {
		DemographicTranslator translator = new DemographicTranslator();
		return translator.translate(arrayOfDemographics);
	}
	
	@Override
	public NextOfKin fetchPatientNextOfKin(PatientIdentifier patientIdentifier) {
		// Next of Kin is not available through the available Vista calls in MDWS; we get this from ADR
		throw new UnsupportedOperationException(); 
	}

	@Override
	public PatientDemographics fetchPatientContactInformation(PatientIdentifier patientIdentifier) {
		EmrConnection authenticatedConnection = super.getAuthenticatedConnection(super.getSiteCodeFromPatientIdentifier(patientIdentifier));
		PatientTO patient = authenticatedConnection.getPort().select(patientIdentifier.getUniqueId());
		ArrayOfDemographicSetTO demographics = patient.getDemographics();
				
		return translate(demographics);
	}

}
