package com.agilex.healthcare.mobilehealthplatform.datalayer.medication;

import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsEmrDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseValidator;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedMedicationArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TextTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.MedicationTranslator;
import com.agilex.healthcare.utility.NullChecker;

public class MedicationDataLayerMdws extends MdwsEmrDataLayer implements MedicationDataLayer {

	public MedicationDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
        super(mdwsConfiguration);
	}

	@Override
	public Medications getMedications(PatientIdentifier patientId, MedicationFilter medicationFilter) {
		Medications medications = getMedications(patientId, false);
//		Medications filteredMedications = MedicationFilterer.filter(medications, medicationFilter);

		return medications;
	}

	@Override
	public Medications getMedications(PatientIdentifier patientId, boolean activeOnly) {

		EmrConnection authenticatedSite = super.getAuthenticatedConnectionWithPatientSelect(patientId);
		TaggedMedicationArrays mdwsTaggedMedicationArrays = authenticatedSite.getPort().getAllMeds();
        super.disconnectFromCdwIfApplicable(authenticatedSite);
		MdwsResponseValidator.validateMdwsObject(mdwsTaggedMedicationArrays);
		
		MedicationTranslator translator = new MedicationTranslator();
		Medications medications = translator.translateFromTaggedMedicationArrays(mdwsTaggedMedicationArrays);

		if (activeOnly)
			medications = this.filterActiveMedications(medications);

		return medications;
	}

	@Override
	public Medication getMedicationLite(PatientIdentifier patientId, String medicationId) {
		Medications medications = this.getMedications(patientId, false);
		Medication medication = this.getSingleMedication(medications, medicationId);

		return medication;
	}

	/* (non-Javadoc)
	 * @see com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataLayer#getMedicationDetail(java.lang.String, java.lang.String)
	 * This method is deprecated as it is not returning accurate results and the same data is provided in detail as a part of other api.
	 * 
	 * For MDWS, the data identifier is not the order ID but the medication ID.
	 * MedicationTranslator.java says "some over-the-counter medications do not have prescription numbers."
	 */
	@Override
	public Medication getMedicationDetail(PatientIdentifier patientId, String medicationId) {
		Medication medication = null;
		String siteCode =  super.getSiteCodeFromPatientIdentifier(patientId);
		
		if (NullChecker.isNotNullish(medicationId)) {
			Medications medications = this.getMedications(patientId, false);
			medication = this.getSingleMedication(medications, medicationId);

			if (medication != null) {
				String uniqueMedicationId = medication.getId();

				TextTO medicationDetail = new TextTO();
				if (NullChecker.isNotNullish(uniqueMedicationId)) {
					EmrConnection authenticatedSite = super.getAuthenticatedConnectionWithPatientSelect(patientId);
					medicationDetail = authenticatedSite.getPort().getMedicationDetail(siteCode, uniqueMedicationId);
					super.disconnectFromCdwIfApplicable(authenticatedSite);
					MdwsResponseValidator.validateMdwsObject(medicationDetail);
				}
				medication.setMedicationDetail(medicationDetail.getText());
			}

			return medication;
		}

		return null;
	}
	
	public Medication getSingleMedication(PatientIdentifier patientIdentifier, String medicationId) {
		Medications medications = this.getMedications(patientIdentifier, false);
		Medication medication = this.getSingleMedication(medications, medicationId);

		return medication;
	}

	Medication getSingleMedication(Medications medications, String medicationId) {
		for (Medication medication : medications) {
			if (NullChecker.isNotNullish(medicationId)) {
				if (medicationId.equalsIgnoreCase(medication.getId()) || medicationId.equalsIgnoreCase(medication.getOrderNumber())) {
					return medication;
				}
			}
		}

		return null;
	}

	Medications filterActiveMedications(Medications medications) {
		Medications activeMedications = new Medications();
		for (Medication medication : medications) {
			if (medication.isActive()) {
				activeMedications.add(medication);
			}
		}

		return activeMedications;
	}

}
