package com.agilex.healthcare.mobilehealthplatform.datalayer.medication;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.mdws.CdwPatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

public class MedicationDataLayerCdw extends CdwPatientDataLayer<Medication, Medications> implements MedicationDataLayer {

	MedicationDataLayerMdws dataLayer;
	
	public MedicationDataLayerCdw(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
		dataLayer = new MedicationDataLayerMdws(mdwsConfiguration);
	}

	@Override
	public Medications getMedications(PatientIdentifier patientIdentifier, MedicationFilter medicationFilter) {
		Medications medications = dataLayer.getMedications(alterForCdw(patientIdentifier), medicationFilter);
		return setIdentifiers(medications, patientIdentifier, SourceSystemCode.CDW);
	}

	@Override
	public Medications getMedications(PatientIdentifier patientIdentifier, boolean activeOnly) {
		Medications medications = dataLayer.getMedications(alterForCdw(patientIdentifier), activeOnly);
		return setIdentifiers(medications, patientIdentifier, SourceSystemCode.CDW);
	}

	@Override
	public Medication getMedicationLite(PatientIdentifier patientIdentifier, String orderNumber) {
		Medication medication = dataLayer.getMedicationLite(alterForCdw(patientIdentifier), orderNumber);
		return setIdentifiers(medication, patientIdentifier, SourceSystemCode.CDW);
	}

	@Override
	public Medication getMedicationDetail(PatientIdentifier patientIdentifier, String medicationId) {
		Medication medication = dataLayer.getSingleMedication(alterForCdw(patientIdentifier), medicationId);
		return setIdentifiers(medication, patientIdentifier, SourceSystemCode.CDW);
	}

}
