package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.NotImplementedException;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro.MicrobiologyLabDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDateTranslationUtil;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsEmrDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseValidator;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedMicrobiologyRptArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfigurationHelper;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.MicrobiologyLabTranslator;
import com.agilex.healthcare.utility.DateHelper;

public class MicrobiologyLabDataLayerMdws extends MdwsEmrDataLayer implements MicrobiologyLabDataLayer {

	private static final String VISTA_START_DATE = "01/01/1980";

	public MicrobiologyLabDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	@Override
	public LabResults getLabResults(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);
		MdwsDateTranslationUtil translationUtil = new MdwsDateTranslationUtil();
		
		String siteType = new MdwsConfigurationHelper().extractSiteTypeFromAssigningAuthority(patientIdentifier.getAssigningAuthority());
		String fromDate = translationUtil.dateFormatBySystem(fromDate(dateFilter.getStartDate()), siteType);
		String toDate = translationUtil.dateFormatBySystem(toDate(dateFilter.getEndDate()), siteType);

		TaggedMicrobiologyRptArrays taggedMicriobiologyReportArrays = authenticatedConnection.getPort().getMicrobiologyReports(fromDate, toDate, 0);
		MdwsResponseValidator.validateMdwsObject(taggedMicriobiologyReportArrays);

		LabResults labResults = translate(taggedMicriobiologyReportArrays);
		correctIdentifiers(labResults, patientIdentifier, siteType);
		return DateFilterer.filterByDate(labResults, dateFilter);
	}

	private LabResults translate(TaggedMicrobiologyRptArrays taggedMicrobiologyReportArrays) {
		MicrobiologyLabTranslator translator = new MicrobiologyLabTranslator();
		return translator.translate(taggedMicrobiologyReportArrays);
	}
	
	private void correctIdentifiers(LabResults labResults, PatientIdentifier patientIdentifier, String system) {
		for(LabResult labResult : labResults) {
			labResult.setPatientIdentifier(patientIdentifier);
			labResult.setSystemId(system);
		}
	}

	private Date fromDate(Date filterStartDate) {
		if (filterStartDate == null)
			return DateHelper.parseDate(VISTA_START_DATE);

		return filterStartDate;
	}

	private Date toDate(Date filterEndDate) {
		if (filterEndDate == null)
			return DateHelper.getToday();

		return filterEndDate;
	}

	@Override
	public LabResults getLabResultsByTestId(PatientIdentifier patientId, String testId) {
		throw new NotImplementedException();
	}

	@Override
	public LabResults getLabResultsLite(String patientId, DateFilter dateFilter) {
		throw new NotImplementedException();
	}

	@Override
	public LabTestGroups lookupLabGroupsByTestId(String labTestId) {
		throw new NotImplementedException();
	}

	@Override
	public Map<String, LabTestGroups> lookupLabGroupsByTestIds(List<String> labTestIds) {
		throw new NotImplementedException();
	}

}
