package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.mdws.CdwPatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

public class ChemistryLabDataLayerCdw extends CdwPatientDataLayer<LabResult, LabResults> implements ChemistryLabDataLayer {

	ChemistryLabDataLayerMdws dataLayer;

	public ChemistryLabDataLayerCdw(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
		dataLayer = new ChemistryLabDataLayerMdws(mdwsConfiguration);
	}

	@Override
	public LabResults getLabResults(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		LabResults labResults = dataLayer.getLabResults(alterForCdw(patientIdentifier), dateFilter);
		return setIdentifiers(labResults, patientIdentifier, SourceSystemCode.CDW);
	}

	@Override
	public LabResults getLabResultsByTestId(PatientIdentifier patientIdentifier, String testId) {
		LabResults labResults = dataLayer.getLabResultsByTestId(alterForCdw(patientIdentifier), testId);
		return setIdentifiers(labResults, patientIdentifier, SourceSystemCode.CDW);
	}

	// Out-dated API methods

	@Override
	public LabResults getLabResultsLite(String patientId, DateFilter dateFilter) {
		return null;
	}

	@Override
	public LabTestGroups lookupLabGroupsByTestId(String labTestId) {
		return null;
	}

	@Override
	public Map<String, LabTestGroups> lookupLabGroupsByTestIds(List<String> labTestIds) {
		return null;
	}

}
