package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresult;

import com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults.AssessmentResultDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsEmrDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedMentalHealthResultSetArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.AssessmentResultTranslator;


public class PclAssessmentResultDataLayerMdws extends MdwsEmrDataLayer implements AssessmentResultDataLayer {

	private String ASSESSMENT_ACRONYM = "PCLC";

	public PclAssessmentResultDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}
	
	@Override
	public AssessmentResult saveAssessmentResult(AssessmentResult assessmentResult) {
		throw new UnsupportedOperationException();
	}

	@Override
	public AssessmentResults fetchAssessmentDraftsByPatient(PatientIdentifier patientIdentifier) {
		throw new UnsupportedOperationException();
	}

	@Override
	public AssessmentResult fetchMostRecentlyCompletedResult(String assessmentId, PatientIdentifier patientIdentifier) {
		throw new UnsupportedOperationException();
	}

	@Override
	public AssessmentResult fetchAssessmentResult(PatientIdentifier patientIdentifier, String resultId) {
		throw new UnsupportedOperationException();
	}

	@Override
	public AssessmentResults fetchResultsByAssessment(PatientIdentifier patientIdentifier, String assessmentId, DateFilter filter) {
		TaggedMentalHealthResultSetArray mdwsPclMentalHealthScores = fetchAssessmentsByUser(patientIdentifier.getUniqueId());
		
		AssessmentResultTranslator translator = new AssessmentResultTranslator();
		AssessmentResults results = translator.translateMentalHealthInstrumentForPatient(mdwsPclMentalHealthScores);
		fixPatientIdentifiers(patientIdentifier, results);
		results = DateFilterer.filterByDate(results, filter);
		
		return results;
	}

	private TaggedMentalHealthResultSetArray fetchAssessmentsByUser(String patientId) {
		//TODO: Integration
		return null;
//		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientId);
//		
//		TaggedMentalHealthResultSetArray pclMentalHealthScores = authenticatedConnection.getPort().getMentalHealthInstrumentResultSetBySurvey(mdwsConfiguration.getSiteCode(), ASSESSMENT_ACRONYM);
//		MdwsResponseValidator.validateMdwsObject(pclMentalHealthScores);
//		
//		return pclMentalHealthScores;
	}
	
	void fixPatientIdentifiers(PatientIdentifier patientIdentifier, AssessmentResults assessmentResults) {
		for(AssessmentResult assessmentResult : assessmentResults) {
			assessmentResult.setPatientIdentifier(patientIdentifier);
		}
	}
	 
}
