package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresult;

import com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults.AssessmentResultDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.mdws.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedMentalHealthResultSetArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfigurationHelper;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.AssessmentResultTranslator;

public class PclAssessmentResultDataLayerCdw extends CdwPatientDataLayer<AssessmentResult, AssessmentResults> implements AssessmentResultDataLayer {

	private String ASSESSMENT_ACRONYM = "PCLC";
	
	public PclAssessmentResultDataLayerCdw(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}
	
	@Override
	public AssessmentResult saveAssessmentResult(AssessmentResult assessmentResult) {
		throw new UnsupportedOperationException();
	}

	@Override
	public AssessmentResults fetchAssessmentDraftsByPatient(PatientIdentifier patientIdentifier) {
		throw new UnsupportedOperationException();
	}

	@Override
	public AssessmentResult fetchMostRecentlyCompletedResult(String assessmentId, PatientIdentifier patientIdentifier) {
		throw new UnsupportedOperationException();
	}

	@Override
	public AssessmentResult fetchAssessmentResult(PatientIdentifier patientIdentifier, String resultId) {
		throw new UnsupportedOperationException();
	}

	@Override
	public AssessmentResults fetchResultsByAssessment(PatientIdentifier patientIdentifier, String assessmentId, DateFilter filter) {
		EmrConnection emrConnection = super.establishCdwConnection();
		emrConnection.getPort().select(alterForCdw(patientIdentifier).getUniqueId());
		
		TaggedMentalHealthResultSetArray pclScores = emrConnection.getPort().getMentalHealthInstrumentResultSetBySurvey(MdwsConfigurationHelper.CDW_SITECODE, ASSESSMENT_ACRONYM);
		super.returnConnection(emrConnection);
		MdwsResponseValidator.validateMdwsObject(pclScores);
		
		AssessmentResults assessmentResults = translate(pclScores);
		
		return super.setIdentifiers(assessmentResults, patientIdentifier, SourceSystemCode.CDW);
	}
	
	private AssessmentResults translate(TaggedMentalHealthResultSetArray mentalHealthResultSetArray) {
		AssessmentResultTranslator translator = new AssessmentResultTranslator();
		return translator.translateMentalHealthInstrumentForPatient(mentalHealthResultSetArray);
	}
	

}
