package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TextTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.*;

public class ClinicalNoteDataLayerMdws extends MdwsEmrDataLayer implements ClinicalNoteDataLayer {

	public ClinicalNoteDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	@Override
	public ProviderNote fetchClinicalNote(PatientIdentifier patientIdentifier, String outpatientVisitId) {
		EmrConnection connection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);
		
		String siteCode =  super.getSiteCodeFromPatientIdentifier(patientIdentifier);
		
		TextTO clinicalNote = connection.getPort().getAppointmentText(siteCode, outpatientVisitId);
		MdwsResponseValidator.validateMdwsObject(clinicalNote);
		super.disconnectFromCdwIfApplicable(connection);

		return new ProviderNote(clinicalNote.getText());
	}

}
