package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.mdws.CdwPatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

public class ClinicalNoteDataLayerCdw extends CdwPatientDataLayer<ProviderNote, ProviderNotes> implements ClinicalNoteDataLayer {

	ClinicalNoteDataLayerMdws dataLayer;
	
	public ClinicalNoteDataLayerCdw(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
		dataLayer = new ClinicalNoteDataLayerMdws(mdwsConfiguration);
	}
	
	@Override
	public ProviderNote fetchClinicalNote(PatientIdentifier patientIdentifier, String outpatientVisitId) {
		ProviderNote clinicNote = dataLayer.fetchClinicalNote(alterForCdw(patientIdentifier), outpatientVisitId);
		
		return setIdentifiers(clinicNote, patientIdentifier, SourceSystemCode.CDW);
	}

}
