package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsEmrDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseValidator;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedAppointmentArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.AppointmentTranslator;

public class AppointmentDataLayerMdws extends MdwsEmrDataLayer implements AppointmentDataLayer, MentalHealthAppointmentDataLayer {

	public AppointmentDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	@Override
	public Appointments getProviderAppointments(String providerId, DateFilter filter) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Appointments getClinicAppointments(String clinicId, DateFilter filter) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Appointments fetchAppointmentsByPatient(PatientIdentifier patientIdentifier, DateFilter filter) {
		return fetchAppointmentsByPatient(patientIdentifier, filter, false);
	}

	// shouldIncludeDetails should be ignored. Notes are now requested separately via ClinicalNoteDataLayer
	@Override
	public Appointments fetchAppointmentsByPatient(PatientIdentifier patientIdentifier, DateFilter filter, boolean shouldIncludeDetails) {

		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);

		TaggedAppointmentArrays taggedAppointments = authenticatedConnection.getPort().getAppointments();

		MdwsResponseValidator.validateMdwsObject(taggedAppointments);
		super.disconnectFromCdwIfApplicable(authenticatedConnection);
		Appointments translated = translate(taggedAppointments);

		Appointments filteredAppointments = null;
		filteredAppointments = filter(translated, filter);

		return filteredAppointments;
	}

	@Override
	public Appointment fetchAppointment(PatientIdentifier patientIdentifier, String appointmentId) {
		Appointments appointments = fetchAppointmentsByPatient(patientIdentifier, DateFilterFactory.createEmptyFilter());
		for (Appointment appointment : appointments) {
			if (appointmentId != null && appointmentId.equalsIgnoreCase(appointment.getUniqueId())) {
				return appointment;
			}
		}
		return null;

	}

	@Override
	public Appointments fetchMentalHealthAppointments(PatientIdentifier patientIdentifier, DateFilter filter) {
		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);
		TaggedAppointmentArrays taggedAppointments = authenticatedConnection.getPort().getMentalHealthAppointments();
		MdwsResponseValidator.validateMdwsObject(taggedAppointments);
		super.disconnectFromCdwIfApplicable(authenticatedConnection);

		Appointments translated = translate(taggedAppointments);
		return filter(translated, filter);
	}

	private Appointments translate(TaggedAppointmentArrays arrays) {
		AppointmentTranslator translator = new AppointmentTranslator();
		return translator.translate(arrays);
	}

	private Appointments filter(Appointments appointments, DateFilter dateFilter) {
		return DateFilterer.filterByDate(appointments, dateFilter);
	}
}
