package com.agilex.healthcare.mobilehealthplatform.datalayer.allergy;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedAllergyArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.AllergyTranslator;

public class AllergyDataLayerMdws extends MdwsEmrDataLayer implements AllergyDataLayer {

	public AllergyDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	@Override
	public Allergies fetchAllergies(PatientIdentifier patientIdentifier, DateFilter filter) {
		String siteCode = super.getSiteCodeFromPatientIdentifier(patientIdentifier);
		
		EmrConnection connection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);
		TaggedAllergyArrays taggedAllergyArrays = connection.getPort().getAllergiesBySite(siteCode);
		
		super.disconnectFromCdwIfApplicable(connection);
		MdwsResponseValidator.validateMdwsObject(taggedAllergyArrays);
		
		Allergies allergies = translate(taggedAllergyArrays);
		
		return filter(allergies, filter);
	}
	
	private Allergies translate(TaggedAllergyArrays taggedAllergyArrays) {
		AllergyTranslator translator = new AllergyTranslator();
		return translator.translate(taggedAllergyArrays);
	}
	
	private Allergies filter(Allergies allergies, DateFilter filter) {
		return DateFilterer.filterByDate(allergies, filter);
	}

}
