package com.agilex.healthcare.mobilehealthplatform.datalayer.allergy;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedAllergyArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.AllergyTranslator;

public class AllergyDataLayerCdw extends CdwRawPatientDataLayer<Allergy, Allergies> implements AllergyDataLayer {

	public AllergyDataLayerCdw(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	@Override
	public Allergies fetchAllergies(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier.getUniqueId());
		TaggedAllergyArrays taggedAllergyArrays = authenticatedConnection.getPort().getAllergiesBySite(super.getSiteCodeFromPatientIdentifier(patientIdentifier));
		super.returnConnection(authenticatedConnection);

		MdwsResponseValidator.validateMdwsObject(taggedAllergyArrays);

		Allergies allergies = translate(taggedAllergyArrays);
		return setIdentifiers(filter(allergies, dateFilter), patientIdentifier, SourceSystemCode.CDW_RAW);
	}

	private Allergies translate(TaggedAllergyArrays taggedAllergyArrays) {
		AllergyTranslator translator = new AllergyTranslator();

		return translator.translate(taggedAllergyArrays);
	}

	private Allergies filter(Allergies allergies, DateFilter dateFilter) {
		return DateFilterer.filterByDate(allergies, dateFilter);
	}

}
