package com.agilex.healthcare.mobilehealthplatform.datalayer.admission;

import java.util.Date;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.ProviderNote;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDateTranslationUtil;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsEmrDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseValidator;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedTextArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.TaggedTextTranslator;

public class DischargeNoteDataLayerMdws extends MdwsEmrDataLayer implements DischargeNoteDataLayer {

	public DischargeNoteDataLayerMdws(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
	}

	@Override
	public ProviderNote fetchDischargeNote(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		EmrConnection authenticatedConnection = super.getAuthenticatedConnectionWithPatientSelect(patientIdentifier);
		
		String siteType = new MdwsConfigurationHelper().extractSiteTypeFromAssigningAuthority(patientIdentifier.getAssigningAuthority());
		
		String startDate = getStartDateAsString(dateFilter.getStartDate(), siteType);
		String endDate = getEndDateAsString(dateFilter.getEndDate(), siteType);
		
		TaggedTextArray reports = authenticatedConnection.getPort().getDischargesReports(startDate, endDate, 10);
		super.disconnectFromCdwIfApplicable(authenticatedConnection);
		MdwsResponseValidator.validateMdwsObject(reports);
		
		return translate(reports);
	}
	
	private ProviderNote translate(TaggedTextArray report) {
		TaggedTextTranslator translator = new TaggedTextTranslator();
		String reportText = translator.translate(report);
		
		return new ProviderNote(reportText);
	}

	private String getStartDateAsString(Date date, String system) {
		MdwsDateTranslationUtil translator = new MdwsDateTranslationUtil();
		return translator.startDateBySystem(date, system);
	}

	private String getEndDateAsString(Date date, String system) {
		MdwsDateTranslationUtil translator = new MdwsDateTranslationUtil();
		return translator.endDateBySystem(date, system);
	}
	
}
