package com.agilex.healthcare.mobilehealthplatform.datalayer.admission;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.mdws.CdwPatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

public class DischargeNoteDataLayerCdw extends CdwPatientDataLayer<ProviderNote, ProviderNotes> implements DischargeNoteDataLayer {

	DischargeNoteDataLayerMdws dataLayer;
	
	public DischargeNoteDataLayerCdw(MdwsConfiguration mdwsConfiguration) {
		super(mdwsConfiguration);
		dataLayer = new DischargeNoteDataLayerMdws(mdwsConfiguration);
	}
	
	@Override
	public ProviderNote fetchDischargeNote(PatientIdentifier patientIdentifier, DateFilter dateFilter) {
		ProviderNote dischargeNote = dataLayer.fetchDischargeNote(alterForCdw(patientIdentifier), dateFilter);
		
		return setIdentifiers(dischargeNote, patientIdentifier, SourceSystemCode.CDW);
	}

}
