package com.agilex.healthcare.mobilehealthplatform.mdws;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.junit.AfterClass;
import org.junit.BeforeClass;

public class VistaTest {
  private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(VistaTest.class);
	@BeforeClass
	public static void login(){
    String SITE_CODE = "500";
    String ACCESS_CODE = "doc123";
    String VERIFY_CODE = "doc123!!";

    Properties p = new Properties();
    try {
      // note: properties file is loading from the classpath; if the int tests are being run through gradle,
      // this file can be placed at the root + /intTest/spring/properties/va-veteran-dev.int.properties
      InputStream is = ClassLoader.getSystemResourceAsStream("spring/properties/va-veteran-dev.int.properties");
      p.load(is);
      SITE_CODE = p.getProperty("mdwslib.inttest.site_code");
      ACCESS_CODE = p.getProperty("mdwslib.inttest.access_code");
      VERIFY_CODE = p.getProperty("mdwslib.inttest.verify_code");
    } catch (IOException e) {

    }
    logger.debug("Using test credentials:");
    logger.debug("Site code - " + SITE_CODE);
    logger.debug("A - " + ACCESS_CODE);
    logger.debug("V - " + VERIFY_CODE);
		AuthenticationUtil.loginUser(SITE_CODE, ACCESS_CODE, VERIFY_CODE, "1");
	}
	@AfterClass
	public static void logoff() {
		AuthenticationUtil.logoffUser();
	}
}
