package com.agilex.healthcare.mobilehealthplatform.mdws;

import java.util.HashMap;

import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.*;

public class MdwsIntegrationTestHelper {
	
	public static MdwsConfiguration getInternalMdwsConfiguration() {
		String endpointUrl = "EmrSvc.asmx";
		VistaSite vistaSite = new VistaSite("ov1234", "ov1234!!", "500");
		HashMap<String, VistaSite> vistaSites = new HashMap<String, VistaSite>();
		vistaSites.put("500", vistaSite);
		
		MdwsConfiguration configuration = new MdwsConfiguration(endpointUrl, 30000, 30000, vistaSites);
		
		return configuration;
	}
	
	public static MhvMdwsConfiguration getInternalMhvConfigurationForMedicationRefill() {
		MhvMdwsConfiguration configuration = new MhvMdwsConfiguration();
		
		configuration.setMdwsSitecode("500");
        configuration.setMdwsEndpointAddress("192.168.25.149");
		configuration.setMdwsEndpointPath("mdwsIPADDRESS;
        configuration.setWsConnectTimeout(30000);
        configuration.setWsRequestTimeout(30000);

		return configuration;
	}
	
	public static MdwsConfiguration getCdwMdwsConfiguration() {
		String endpointUrl = "http://192.168.25.149/mdwsIPADDRESSmrSvc.asmx";
		VistaSite vistaSite = new VistaSite("dev", "dev", "204");
		HashMap<String, VistaSite> vistaSites = new HashMap<String, VistaSite>();
		vistaSites.put("204", vistaSite);
		
		MdwsConfiguration configuration = new MdwsConfiguration(endpointUrl, 30000, 30000, vistaSites);
		
		return configuration;
	}
	
	public static MdwsConfiguration getCdwRawMdwsConfiguration() {
		String endpointUrl = "http://IPADDRESS  /mdwsIPADDRESSmrSvc.asmx";
		VistaSite vistaSite = new VistaSite("dev", "dev", "205");
		HashMap<String, VistaSite> vistaSites = new HashMap<String, VistaSite>();
		vistaSites.put("205", vistaSite);
		
		MdwsConfiguration configuration = new MdwsConfiguration(endpointUrl, 30000, 30000, vistaSites);
		
		return configuration;
	}
}
