package com.agilex.healthcare.mobilehealthplatform.mdws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.DefaultAuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.connection.EmrConnection;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.VistaSite;
import com.agilex.healthcare.mobilehealthplatform.security.AppUser;
import com.agilex.healthcare.mobilehealthplatform.security.Roles;
import com.agilex.healthcare.mobilehealthplatform.security.VistaAuthenticator;

public class AuthenticationUtil {
	public static String EMR_SVC = "EmrSvc.asmx";
	public static String EMR_SVC_BASE_URL = "http://192.168.25.149/mdws3.0.2.5/";

	public static void loginUser(String siteCode, String accessCode, String verifyCode, String uniqueId) {
		String service = AuthenticationUtil.EMR_SVC;
		String baseService = AuthenticationUtil.EMR_SVC_BASE_URL;

    Properties p = new Properties();
    try {
      // note: properties file is loading from the classpath; if the int tests are being run through gradle,
      // this file can be placed at the root + /intTest/spring/properties/va-veteran-dev.int.properties
      InputStream is = ClassLoader.getSystemResourceAsStream("spring/properties/va-veteran-dev.int.properties");
      p.load(is);
      baseService = p.getProperty("mdws.EmrSvcEndPointBaseUrl");
    } catch (IOException e) {
      baseService = AuthenticationUtil.EMR_SVC_BASE_URL;
    }

		Authentication userAuthentication = createUserAuthentication(baseService, service, siteCode, accessCode, verifyCode, uniqueId);
		final Authentication oauthAuthentication = createOauth2Authentication(userAuthentication);

		SecurityContext context = new SecurityContext() {
			private static final long serialVersionUID = -7841498566548092084L;

			@Override
			public void setAuthentication(Authentication authentication) {

			}

			@Override
			public Authentication getAuthentication() {
				return oauthAuthentication;
			}
		};
		SecurityContextHolder.setContext(context);
	}

	public static void logoffUser() {
		MhpUser mhpUser = getMhpUser();
		String baseUrl = mhpUser.getMdwsInfo().getBaseUrl();

		String endPointUrl = AuthenticationUtil.EMR_SVC;
		MdwsConfiguration configuration = new MdwsConfiguration(baseUrl, endPointUrl, 0, 0, new HashMap<String, VistaSite>());
		EmrConnection connectedPort = new EmrConnection(configuration,"ignored", true);
		connectedPort.getPort().disconnect();
	}

	public static MhpUser getMhpUser(){
        SecurityContext ctx = SecurityContextHolder.getContext();

        AppUser appUser = (AppUser) ctx.getAuthentication().getPrincipal();
        MhpUser mhpUser = appUser.getMhpUser();
		mhpUser.setUserName(appUser.getUsername());

        return mhpUser;
	}


	private static Authentication createUserAuthentication(String baseService, String service, String siteCode, String accessCode, String verifyCode, String uniqueId){
		List<GrantedAuthority> authorities = createPatientAuthorities();

		AppUser principal = createPrincipal(new PatientIdentifier(siteCode, uniqueId), authorities, baseService, service, siteCode, accessCode, verifyCode);

		Object credentials = null;

		Authentication authentication = createAuthentication(authorities, principal, credentials);
		return authentication;
	}

    protected static UsernamePasswordAuthenticationToken createAuthentication(List<GrantedAuthority> authorities, AppUser principal, Object credentials) {
        return new UsernamePasswordAuthenticationToken(principal, credentials, authorities);
    }
    protected static List<GrantedAuthority> createPatientAuthorities() {
		return createAuthorities(Roles.ROLE_CONSUMER);
	}
    protected static AppUser createPrincipal(PatientIdentifier patientIdentifier, List<GrantedAuthority> authorities, String baseService, String service, String siteCode, String accessCode, String verifyCode) {
		MhpUser authenticatedUser = new MhpUser();
		authenticatedUser.setAccessCode(accessCode);
        authenticatedUser.setUserIdentifier(patientIdentifier);
        authenticatedUser.setRightOfAccessAccepted(true);

        VistaAuthenticator vistaAuthenticator = new VistaAuthenticator(baseService, service);
        try {
			authenticatedUser = vistaAuthenticator.authenticate(accessCode, verifyCode, siteCode);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		AppUser principal = new AppUser(accessCode, "", authorities, authenticatedUser);
		return principal;
	}

	protected static List<GrantedAuthority> createAuthorities(String role) {
		List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
		authorities.add(new SimpleGrantedAuthority(role));
		return authorities;
	}
    private static OAuth2Authentication createOauth2Authentication(Authentication userAuthentication){
    	return new OAuth2Authentication(new DefaultAuthorizationRequest(
    			Collections.<String, String> emptyMap()), userAuthentication);
    }
}
