package com.agilex.healthcare.mobilehealthplatform.mdws;

import static org.junit.Assert.*;

import javax.annotation.Resource;

import org.junit.*;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.mdws.connection.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.*;

@Ignore
@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class AuthenticationExploratoryTest {

	private static final String DEFAULT_SITE_CODE = "500";
	private static final String DEFAULT_SITE_LOGIN = "ov1234";
	private static final String DEFAULT_SITE_PASSWORD = "ov1234!!";

	@Resource
	MdwsConfiguration mdwsConfiguration; 
	
	@Test
	public void validateFirstUserLogin(){
		authenticateAndValidateResponse(DEFAULT_SITE_LOGIN, DEFAULT_SITE_PASSWORD, "USER,OVID");
	}

	@Test
	public void validateSecondUserLogin() {
		authenticateAndValidateResponse("doc123", "doc123!!", "PROVIDER,ONE");
	}

	@Test
	public void validateInvalidSiteCode() {
		EmrSvcSoap port = createEmrSvcPort();
		
		DataSourceArray connect = port.connect("xyz");
		assertEquals("Site not in site table", connect.getFault().getMessage());

	}

	@Test
	public void validateInvalidUserCredentials() {
		EmrSvcSoap port = createEmrSvcPort();
		
		DataSourceArray connect = port.connect(DEFAULT_SITE_CODE);
		assertNull(connect.getFault());

		UserTO userTO = port.login("none", "none!!", "");
		assertEquals("Not a valid ACCESS CODE/VERIFY CODE pair.", userTO.getFault().getMessage());

	}

	private void authenticateAndValidateResponse(String accessCode, String verifyCode, String expectedUserName) {
		EmrSvcSoap port = createEmrSvcPort();
		
		DataSourceArray connect = port.connect(DEFAULT_SITE_CODE);
		assertNull(connect.getFault());
		
		UserTO userTO = port.login(accessCode, verifyCode, "");
		assertNull(userTO.getFault());
		assertEquals(expectedUserName, userTO.getName());
	}

	private EmrSvcSoap createEmrSvcPort() {
		EmrConnectionManager connectionManager = EmrConnectionManagerFactory.getInstance();
		EmrConnection siteConnection = connectionManager.getSiteConnection(mdwsConfiguration, DEFAULT_SITE_CODE);
		return siteConnection.getPort();
	}
}
