package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.vital;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import javax.annotation.Resource;

import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalEntryFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.utility.DateHelper;

@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class VitalDataLayerMdwsVistaTest extends VistaTest{
	
	private final PatientIdentifier PATIENT_ID = new PatientIdentifier("DFN-500", "237");
	private final String PULSE_VITAL_ID_FOR_PATIENT_ID_237 = "25420";
	
	@Resource
	MdwsConfiguration mdwsVistaConfiguration;
	
	@Test
	public void verifyGetVitalEntriesFromVista() {
		
		VitalDataLayerMdws dl = new VitalDataLayerMdws(mdwsVistaConfiguration);
		VitalEntries entries = dl.fetchVitalEntries(PATIENT_ID, new VitalEntryFilter());
		
		assertNotNull(entries);
		assertTrue(String.format("[size: %s]", entries.size()), entries.size() >= 334);
	}
	
	@Test
	public void verifyGetVitalEntriesFromVistaBySectionFilter() {
		
		VitalDataLayerMdws dl = new VitalDataLayerMdws(mdwsVistaConfiguration);
		VitalEntryFilter filter = new VitalEntryFilter();
		filter.setSection("temperature");
		VitalEntries entries = dl.fetchVitalEntries(PATIENT_ID, filter);
		
		assertNotNull(entries);
		assertTrue(String.format("[size: %s]", entries.size()), entries.size() >= 34);
	}

	@Test
	public void verifyGetVitalEntriesFromVistaByStartDateFilter() {
		
		VitalDataLayerMdws dl = new VitalDataLayerMdws(mdwsVistaConfiguration);
		VitalEntryFilter filter = new VitalEntryFilter();
		filter.setSection("temperature");
		filter.setStartDate(DateHelper.parseDate("01/25/2011"));
		VitalEntries entries = dl.fetchVitalEntries(PATIENT_ID, filter);
		
		assertNotNull(entries);
		assertTrue(String.format("[size: %s]", entries.size()), entries.size() >= 1);
	}
	
	// The following test will run only if vital Id is passed through from MDWS. This is a bug on MDWS side.
	@Ignore
	@Test
	public void verifyGetVitalEntryByIdFromVista() {
		
		VitalDataLayerMdws dl = new VitalDataLayerMdws(mdwsVistaConfiguration);
		VitalEntry entry = dl.fetchVitalEntry(PATIENT_ID, PULSE_VITAL_ID_FOR_PATIENT_ID_237);
		
		assertNotNull(entry);
		String val = entry.getSection();
		System.out.println(val);
	}
	
}
