package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.radiology;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.radiology.RadiologyDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResults;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.utility.DateHelper;

@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class RadiologyDataLayerMdwsVistaTest extends VistaTest{
	
	//NOTE: patient ids that have radiology data are : 21, 237, 736.
	
	@Resource
	MdwsConfiguration mdwsVistaConfiguration;

	@Test
	public void verifyRetrievalFromVista() {
		PatientIdentifier identifier = new PatientIdentifier("dfn-500", "237");
		//String patientId = "237";
		DateFilter filter = DateFilterFactory.createFilterFromDate(DateHelper.parseDate("01/01/1990"), DateHelper.getToday());

		RadiologyDataLayerMdws dl = new RadiologyDataLayerMdws(mdwsVistaConfiguration); 
		RadiologyResults results = dl.getResults(identifier, filter);
		
		assertNotNull(results);
		assertTrue(results.size() >= 2);
	}
	
	@Test
	public void verifyRetrievalFromVistaWithDateFilter() {
		DateFilter filter = DateFilterFactory.createFilterFromDate(DateHelper.parseDate("01/01/2000"), DateHelper.getToday());
		PatientIdentifier identifier = new PatientIdentifier("dfn-500", "237");
		//String patientId = "237"; // 21 and 736
		RadiologyDataLayerMdws dl = new RadiologyDataLayerMdws(mdwsVistaConfiguration);
		RadiologyResults results = dl.getResults(identifier, filter);
		
		assertNotNull(results);
		assertTrue(results.size() >= 1);
	}
}
