package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.problem;

import static org.junit.Assert.assertTrue;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.utility.DateHelper;

@Ignore("TODO: ensure data consistency with MDWS / test vista site")
@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class ProblemDataLayerMdwsVistaTest extends VistaTest{

	private final PatientIdentifier VISTA_TEST_PATIENT_ID = new PatientIdentifier("dfn-500", "100844");

	@Resource
	MdwsConfiguration mdwsConfiguration;

	@Test
	public void verifyGetPatientProblemsFromVista() {
		ProblemDataLayerMdws dl = new ProblemDataLayerMdws(mdwsConfiguration);
		Problems problems = dl.fetchProblems(VISTA_TEST_PATIENT_ID, DateFilterFactory.createEmptyFilter());

		assertTrue(String.format("[size: %s]", problems.size()), problems.size() >= 3);
	}

	@Test
	public void verifyGetPatientProblemsFromVistaWithDateFilter() {
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(DateHelper.parseDate("05/01/2012"), DateHelper.getToday());
		ProblemDataLayerMdws dl = new ProblemDataLayerMdws(mdwsConfiguration);
		Problems problems = dl.fetchProblems(VISTA_TEST_PATIENT_ID, dateFilter);
		assertTrue(String.format("size was %s", problems.size()), problems.size() == 0);
	}

}
