package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import javax.annotation.Resource;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

@Ignore
@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class PatientSearchMdwsVistaTest extends VistaTest{

	@Resource(name = "patientTest")
	Patient patientTest;

	@Resource
	MdwsConfiguration mdwsVistaConfiguration;

	private PatientDataLayerMdws datalayer;

	@Before
	public void setup(){
		datalayer = new PatientDataLayerMdws(mdwsVistaConfiguration);
	}
	
	@Test
	public void retrievePatientTestSpringData() {
		
		assertEqualsIgnoreCase(patientTest.getDisplayName(), "Ill,Patient");
	}


	//Marking this test as ignore as the search if needed needs to be fixed on MDWS
	@Ignore
	@Test
	public void searchPatientByLastname() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(new Patient());
		criteria.getPrototype().setLastName(patientTest.getLastName());

		Patients patients = datalayer.patientSearch(criteria);
		assertNotNull(patients);
		assertEquals(1, patients.size());
	}

	@Test(expected = IllegalArgumentException.class)
	public void searchPatientInsufficientCriteria() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		datalayer.patientSearch(criteria);
	}

	//Marking this test as ignore as the search if needed needs to be fixed on MDWS
	@Ignore
	@Test
	public void searchWithNoResults() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(new Patient());
		criteria.getPrototype().setLastName("XXX");

		Patients patients = datalayer.patientSearch(criteria);
		assertNotNull(patients);
		assertEquals(0, patients.size());
	}

	@Test
	public void searchPatientBySsn() {
		System.out.println("Patient Test is "+patientTest.getLastName());
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setVistaSiteCode("500");
		Patient prototype = new Patient();
		criteria.setPrototype(prototype);
		prototype.setSsn(patientTest.getSsn());
		Patients patients = datalayer.patientSearch(criteria);
		System.out.println("Patient Size is "+patients.getSize());
		Patient patient = patients.get(0);
		System.out.println("spring data "+patientTest.getDisplayName()+" mdws data "+patient.getDisplayName());
		assertEqualsIgnoreCase(patientTest.getDisplayName(), patient.getDisplayName());
		System.out.println("after spring data "+patientTest.getDisplayName()+" mdws data "+patient.getDisplayName());
	}


	@Test
	public void searchPatientBySsnWithSearchString() {
		System.out.println("Patient Test is "+patientTest.getLastName());
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setVistaSiteCode("500");
		criteria.setSearchString(patientTest.getSsn());
		Patients patients = datalayer.patientSearch(criteria);
		Patient patient = patients.get(0);
		System.out.println("spring data ssn "+patientTest.getLastName()+" mdws data "+patient.getLastName());
		assertEqualsIgnoreCase(patientTest.getLastName(), patient.getLastName());
	}

	@Test
	public void searchPatientByInitialPlusLastFourSsn() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setVistaSiteCode("500");
		criteria.setLastInitialPlusLastFourOfSsn(extractInitialSsn(patientTest));
		Patients patients = datalayer.patientSearch(criteria);
		Patient patient = patients.get(0);
		assertEquals(patientTest.getLastName().toLowerCase(), patient.getLastName().toLowerCase());
	}

	private String extractInitialSsn(Patient patient) {
		return patient.getLastName().substring(0, 1) + patient.getSsn().substring(5);
	}

	@Test
	public void searchPatientByInitialPlusLastFourSsnWithSearchString() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setVistaSiteCode("500");
		criteria.setSearchString(extractInitialSsn(patientTest));
		Patients patients = datalayer.patientSearch(criteria);
		Patient patient = patients.get(0);
		assertEquals(patientTest.getLastName().toLowerCase(), patient.getLastName().toLowerCase());
	}

	@Test
	public void searchPatientByLastFourSsnWithSearchString() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setVistaSiteCode("500");
		criteria.setSearchString(extractInitialSsn(patientTest));
		Patients patients = datalayer.patientSearch(criteria);
		Patient patient = patients.get(0);
		assertEquals(patientTest.getLastName().toLowerCase(), patient.getLastName().toLowerCase());
	}

	@Test
	public void searchPatientByLastFourSsn() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setVistaSiteCode("500");
		criteria.setLastFourOfSsn(extractInitialSsn(patientTest));
		Patients patients = datalayer.patientSearch(criteria);
		Patient patient = patients.get(0);
		assertEquals(patientTest.getLastName().toLowerCase(), patient.getLastName().toLowerCase());
	}

	private void assertEqualsIgnoreCase(String expected, String actual) {
		if (expected != null)
			expected = expected.toLowerCase();
		if (actual != null)
			actual = actual.toLowerCase();
		assertEquals(expected, actual);
	}
	
}
