package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.patient;

import static org.junit.Assert.assertEquals;

import javax.annotation.Resource;

import org.apache.commons.beanutils.BeanUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

@Ignore("TODO: ensure data consistency with MDWS / test vista site")
@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class PatientSearchFieldMdwsVistaTest extends VistaTest{

	@Resource
	Patient patientTest;

	@Resource
	MdwsConfiguration mdwsConfiguration;

	private PatientDataLayerMdws datalayer;

	private Patient retrievedPatientViaSearch = null;

	@Before
	public void setup(){
		datalayer = new PatientDataLayerMdws(mdwsConfiguration);

	}

	private Patient retrievePatientViaPatientSearch(Patient prototype) {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setVistaSiteCode("500");
		criteria.setPrototype(prototype);
		Patients patients = datalayer.patientSearch(criteria);
		return patients.get(0);
	}

	@Test
	public void retrievePatientTestSpringData() {

		assertEqualsIgnoreCase(patientTest.getDisplayName(), "Ill,Patient");
	}

	@Test
	public void retrievePatientContainDisplayName() {
		retrievedPatientViaSearch = retrievePatientViaPatientSearch(patientTest);
		assertEqualsIgnoreCase(patientTest.getDisplayName(), retrievedPatientViaSearch.getDisplayName());
	}

	@Test
	public void retrievePatientContainsLastName() {
		retrievedPatientViaSearch = retrievePatientViaPatientSearch(patientTest);
		assertEqualsIgnoreCase(patientTest.getLastName(), retrievedPatientViaSearch.getLastName());
	}

	@Test
	public void retrievePatientContainsFirstName() {
		retrievedPatientViaSearch = retrievePatientViaPatientSearch(patientTest);
		assertEqualsIgnoreCase(patientTest.getFirstName(), retrievedPatientViaSearch.getFirstName());
	}

	@Test
	public void retrievePatientContainsId() {
		retrievedPatientViaSearch = retrievePatientViaPatientSearch(patientTest);
		assertEqualsIgnoreCase(patientTest.getId(), retrievedPatientViaSearch.getId());
	}

	@Test
	public void retrievePatientContainsSsnGender() {

		Patient prototype = new Patient();
		try {
			BeanUtils.copyProperties(prototype, patientTest);
		} catch (Exception e) {
			e.printStackTrace();
			assert(false);
		}
		prototype.setFirstName(patientTest.getFirstName());
		prototype.setDisplayName(patientTest.getDisplayName());
		prototype.setGender(patientTest.getGender());
		prototype.setGender(patientTest.getSsn());
		prototype.setId(patientTest.getId());
		prototype.setPatientIdentifier(patientTest.getPatientIdentifier());
		prototype.setLastName(null);
		retrievedPatientViaSearch = retrievePatientViaPatientSearch(prototype);
		assertEqualsIgnoreCase(patientTest.getSsn(), retrievedPatientViaSearch.getSsn());
		assertEqualsIgnoreCase(null, retrievedPatientViaSearch.getGender());
	}

	@Test
	public void retrievePatientContainsStatus() {
		retrievedPatientViaSearch = retrievePatientViaPatientSearch(patientTest);
		assertEquals(patientTest.isInpatient(), retrievedPatientViaSearch.isInpatient());
	}


	private void assertEqualsIgnoreCase(String expected, String actual) {
		if (expected != null)
			expected = expected.toLowerCase();
		if (actual != null)
			actual = actual.toLowerCase();
		assertEquals(expected, actual);
	}

}
